#ifndef OTC_COLLCTN_STRGACTN_HH
#define OTC_COLLCTN_STRGACTN_HH
/*
// ============================================================================
//
// = LIBRARY
//     OTC
// 
// = FILENAME
//     collctn/strgactn.hh
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1994 TELSTRA CORPORATION LIMITED
//     Copyright 1994 DUMPLETON SOFTWARE CONSULTING PTY LIMITED
//
// ============================================================================
*/

#ifndef OTC_COLLCTN_HASHACTN_HH
#include <OTC/collctn/hashactn.hh>
#endif
#ifndef OTC_COLLCTN_RANKACTN_HH
#include <OTC/collctn/rankactn.hh>
#endif
#ifndef OTC_COLLCTN_COPYACTN_HH
#include <OTC/collctn/copyactn.hh>
#endif

#ifdef __GNUG__
#if (__GNUC__ >= 3 || __GNUC_MINOR__ >= 6) || defined(CXX_CYGNUS)
#pragma interface "OTC/collctn/strgactn.hh"
#else
#pragma interface
#endif
#endif

/* ------------------------------------------------------------------------- */

#if defined(CXX_SUN3_0)
typedef OTC_HashActions<void*> otc_collctn_hashactn_hh_typedef1;
#endif

#ifdef __OSE_TEMPLATES__
OSE_MARK_TEMPLATE OTC_HashActions<char*>;
OSE_MARK_TEMPLATE OTC_HashActions<char const*>;
OSE_MARK_TEMPLATE OTC_HashActions<const char*>;
#endif

#if defined(CXX_OS)
typedef OTC_HashActions<char*> otc_collctn_hashactn_typedef1;
#pragma ObjectStore exclude_instantiations OTC_HashActions<char*>;
typedef OTC_HashActions<char const*> otc_collctn_hashactn_typedef2;
#pragma ObjectStore exclude_instantiations OTC_HashActions<char const*>;
#endif

extern int otclib_hash(char const*);
extern int otclib_hash(char const*, int);

#if !defined(CXX_OS)
class OTC_HashActions<char*>
{
  public:
    static int          hash(char* const& s)
				{ return otclib_hash(s); }
};

class OTC_HashActions<const char*>
{
  public:
    static int          hash(const char* const& s)
				{ return otclib_hash(s); }
};

#ifdef __OSE_TEMPLATES__
class OTC_HashActions<char const*>
{
  public:
    static int          hash(char const* s)
				{ return otclib_hash(s); }

};
#endif
#endif

/* ------------------------------------------------------------------------- */

#if defined(CXX_SUN3_0)
typedef OTC_RankActions<void*> otc_collctn_rankactn_hh_typedef1;
#endif

#ifdef __OSE_TEMPLATES__
OSE_MARK_TEMPLATE OTC_RankActions<char*>;
OSE_MARK_TEMPLATE OTC_RankActions<char const*>;
OSE_MARK_TEMPLATE OTC_RankActions<const char*>;
#endif

#if defined(CXX_OS)
typedef OTC_RankActions<char*> otc_collctn_rankactn_typedef1;
#pragma ObjectStore exclude_instantiations OTC_RankActions<char*>;
typedef OTC_RankActions<const char*> otc_collctn_rankactn_typedef2;
#pragma ObjectStore exclude_instantiations OTC_RankActions<const char*>;
#endif

extern int otclib_rank(char const*, char const*);

#if !defined(CXX_OS)
class OTC_RankActions<char*>
{
  public:
    static int          rank(char* const& s1, char* const& s2)
				{ return otclib_rank(s1,s2); }
};

class OTC_RankActions<const char*>
{
  public:
    static int          rank(const char* const& s1, const char* const& s2)
				{ return otclib_rank(s1,s2); }
};

#ifdef __OSE_TEMPLATES__
class OTC_RankActions<char const*>
{
  public:
    static int          rank(char const* s1, const char* s2)
				{ return otclib_rank(s1,s2); }

};
#endif
#endif

/* ------------------------------------------------------------------------- */

extern void otclib_memmove(char*, char const*, size_t);

#if defined(CXX_SUN3_0)
typedef OTC_CopyActions<void*> otc_collctn_copyactn_hh_typedef1;
#endif

#ifdef __OSE_TEMPLATES__
OSE_MARK_TEMPLATE OTC_CopyActions<char>;
#endif

#if defined(CXX_OS)
typedef OTC_CopyActions<char> otc_collctn_copyactn_typedef1;
#pragma ObjectStore exclude_instantiations OTC_CopyActions<char>;
#endif

#if !defined(CXX_OS)
class OTC_CopyActions<char>
{
  public:
    static void		copy(char* s1, char const* s2, size_t l)
				{ otclib_memmove(s1,s2,l); }
};
#endif

/* ------------------------------------------------------------------------- */

#endif /* OTC_COLLCTN_STRGACTN_HH */
