#ifndef OTC_COLLCTN_TBLENTRY_HH
#define OTC_COLLCTN_TBLENTRY_HH
/*
// ============================================================================
//
// = LIBRARY
//     OTC
// 
// = FILENAME
//     collctn/tblentry.hh
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1992 1993 OTC LIMITED
//     Copyright 1994 1995 DUMPLETON SOFTWARE CONSULTING PTY LIMITED
//
// ============================================================================
*/

#include <OTC/OTC.h>

#ifdef __GNUG__
#if (__GNUC__ >= 3 || __GNUC_MINOR__ >= 6) || defined(CXX_CYGNUS)
#pragma interface "OTC/collctn/tblentry.hh"
#else
#pragma interface
#endif
#endif

/* ------------------------------------------------------------------------- */

class OTC_Link;

enum OTC_TableEntryState
{
  OTCLIB_EMPTY,
  OTCLIB_OCCUPIED,
  OTCLIB_DELETED
};

class OTC_TableEntry
    // = TITLE
    //     Holder of table entries in hash based collections.
    //
    // = CLASS TYPE
    //     Concrete
    //
    // = DESCRIPTION
    //     This class contains information about entries in a hash based
    //     collections.
{
  public:

#if defined(ENV_OSTORE) && !defined(SCHEMA_GENERATION)

    static os_typespec* typespec();

    // The inline method here doesn't work for ObjectStore C++.
    // Have to fall back to requiring that <OTC_TableEntry> is
    // marked in the schema file even if not used persistently.
    // This is okay as it is in the schema file which is always
    // dragged in when OSE is used.

#if defined(CXX_OS)
    static os_typespec* get_os_typespec();
#else
    static os_typespec* get_os_typespec() { return typespec(); }
#endif

#endif

			~OTC_TableEntry();

    // = INITIALISATION

			OTC_TableEntry();
				// Default constructor used when creating
				// the vector used for the table.
				// The entry is initialised to be empty.

			OTC_TableEntry(OTC_TableEntry const& theEntry);
				// Construct the table entry from <theEntry>.

			OTC_TableEntry(int theHashValue, OTC_Link* theLink);
				// Construct the table entry such that it
				// holds <theLink>. The value to be used
				// as the cached hash value should be in
				// <theHashValue>.

    OTC_TableEntry&	operator=(OTC_TableEntry const& theEntry);
				// Sets this entry to hold the item
				// held by <theEntry>.

    // = QUERY

    OTC_Boolean		isEmpty() const
				{ return myState == OTCLIB_EMPTY; }
				// Returns <OTCLIB_TRUE> if the entry is
				// still empty.

    OTC_Boolean		isOccupied() const
				{ return myState == OTCLIB_OCCUPIED; }
				// Returns <OTCLIB_TRUE> if the entry is still
				// occupied.

    OTC_Boolean		isDeleted() const
				{ return myState == OTCLIB_DELETED; }
				// Returns <OTCLIB_TRUE> if the item in the
				// entry has been deleted.

    int			hashValue() const
				{ return myHashValue; }
				// Returns the cached hash value for the
				// item.

    OTC_Link*		link() const
				{ return myLink; }
				// Returns the link holding the actual
				// item.

    // = UPDATE

    void		markDeleted()
				{ myState = OTCLIB_DELETED; myLink = 0; }
				// Mark the item in the entry as being
				// deleted.

  private:

    OTC_TableEntryState	myState;
				// State of entry.

    int			myHashValue;
				// The cached hash value of the item.

    OTC_Link*		myLink;
				// The link holding the actual item.
};

/* ------------------------------------------------------------------------- */

#endif /* OTC_COLLCTN_TBLENTRY_HH */
