#ifndef OTC_COLLCTN_TRIPLE_HH
#define OTC_COLLCTN_TRIPLE_HH
/*
// ============================================================================
//
// = LIBRARY
//     OTC
// 
// = FILENAME
//     collctn/triple.hh
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1993 TELSTRA CORPORATION LIMITED
//     Copyright 1995 DUMPLETON SOFTWARE CONSULTING PTY LIMITED
//
// ============================================================================
*/

#include <OTC/memory/mpobject.hh>

#ifdef __GNUG__
#if defined(EXPAND_TEMPLATES)
#pragma implementation "OTC/collctn/triple.hh"
#if (__GNUC__ >= 3 || __GNUC_MINOR__ >= 6) || defined(CXX_CYGNUS)
#pragma interface "OTC/collctn/triple.hh"
#else
#pragma interface
#endif
#endif
#endif

/* ------------------------------------------------------------------------- */

template<class T1, class T2, class T3>
class OTC_Triple : public OTC_MPObject
    // = TITLE
    //     Template class for encapsulating three values.
    //
    // = CLASS TYPE
    //     Concrete
    //
    // = DESCRIPTION
    //     The <OTC_Triple> class can be used to encapsulate three values.
    //     This facilitates returning of three values from a function.
    //     The class also allows the allocation of triples in the common
    //     memory pool.
    //
    // = SEE ALSO
    //     <OTC_Single>, <OTC_Pair>
{
  public:

    // = INITIALISATION

			OTC_Triple(
			 T1 const& theFirst,
			 T2 const& theSecond,
			 T3 const& theThird
			)
			  : myFirst(theFirst),
			    mySecond(theSecond),
			    myThird(theThird)
				{}
				// Sets the value of this triple to
				// <theFirst>, <theSecond> and <theThird>.

			OTC_Triple(OTC_Triple<T1,T2,T3> const& theTriple)
			  : myFirst(theTriple.myFirst),
			    mySecond(theTriple.mySecond),
			    myThird(theTriple.myThird)
				{}
				// Sets the value of this triple to that
				// of <theTriple>.

    // = ASSIGNMENT

    OTC_Triple<T1,T2,T3>&	operator=(
				 OTC_Triple<T1,T2,T3> const& theTriple
				)
				{
				  myFirst = theTriple.myFirst;
				  mySecond = theTriple.mySecond;
				  myThird = theTriple.myThird;
				  return *this;
				}
				// Sets the value of this triple to that
				// of <theTriple>.

    // = ACCESS

    T1 const&		first() const
				{ return myFirst; }
				// Returns the first value in this triple.

    T1&			first()
				{ return myFirst; }
				// Returns the first value in this triple.

    T2 const&		second() const
				{ return mySecond; }
				// Returns the second value in this triple.

    T2&			second()
				{ return mySecond; }
				// Returns the second value in this triple.

    T3 const&		third() const
				{ return myThird; }
				// Returns the third value in this triple.

    T3&			third()
				{ return myThird; }
				// Returns the third value in this triple.

  public:

#if defined(ENV_OSTORE)
    static os_typespec* get_os_typespec();
#endif

  private:

    T1			myFirst;
				// The first value in the triple.

    T2			mySecond;
				// The second value in the triple.

    T3			myThird;
				// The third value in the triple.
};

/* ------------------------------------------------------------------------- */

#endif /* OTC_COLLCTN_TRIPLE_HH */
