#ifndef OTC_COLLCTN_VECTOR_C
#define OTC_COLLCTN_VECTOR_C
/*
// ============================================================================
//
// = LIBRARY
//     OTC
// 
// = FILENAME
//     collctn/vector.c
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1991 1992 1993 OTC LIMITED
//     Copyright 1995 DUMPLETON SOFTWARE CONSULTING PTY LIMITED
//
// ============================================================================
*/

#ifdef __OSE_TEMPLATES__
template<class T> OTC_Vector
{
  OSE_IMPLEMENT OTC_CopyActions<T>;
};
#endif

/* ------------------------------------------------------------------------- */
template<class T>
OTC_Vector<T>::OTC_Vector(u_int theSize)
  : mySize(theSize)
{
#if defined(ENV_OSTORE_DML) || defined(ENV_OSTORE)
  OTC_Locality theLocality = OTC_Locality::of(this);
#endif

#if defined(ENV_OSTORE_DML)
  myVector = new ((os_segment*)theLocality) T[mySize];
#else
#if defined(ENV_OSTORE)
  myVector = new (theLocality,OTC_TypeSpec<T>::typespec(),mySize) T[mySize];
#else
  myVector = new T[mySize];
#endif
#endif
  OTCLIB_ASSERT(myVector != 0);
}

/* ------------------------------------------------------------------------- */
template<class T>
OTC_Vector<T>::OTC_Vector(OTC_Vector<T> const& theVector)
  : mySize(theVector.mySize)
{
#if defined(ENV_OSTORE_DML) || defined(ENV_OSTORE)
  OTC_Locality theLocality = OTC_Locality::of(this);
#endif

#if defined(ENV_OSTORE_DML)
  myVector = new ((os_segment*)theLocality) T[mySize];
#else
#if defined(ENV_OSTORE)
  myVector = new (theLocality,OTC_TypeSpec<T>::typespec(),mySize) T[mySize];
#else
  myVector = new T[mySize];
#endif
#endif
  OTCLIB_ASSERT(myVector != 0);

  OTC_CopyActions<T>::copy(myVector,theVector.myVector,mySize);
}

/* ------------------------------------------------------------------------- */
template<class T>
OTC_Vector<T>::OTC_Vector(
 OTC_Vector<T> const& theVector,
 OTC_Range const& theRange
)
  : mySize(theRange.length())
{
  OTCLIB_ENSURE((theRange.length() != 0),
   "OTC_Vector::OTC_Vector() - invalid size");
  OTCLIB_ENSURE((theRange.lower() >= 0),
   "OTC_Vector::OTC_Vector() - invalid lower bound");
  OTCLIB_ENSURE((theRange.upper() <= (int)theVector.mySize),
   "OTC_Vector::OTC_Vector() - invalid range");

#if defined(ENV_OSTORE_DML) || defined(ENV_OSTORE)
  OTC_Locality theLocality = OTC_Locality::of(this);
#endif

#if defined(ENV_OSTORE_DML)
  myVector = new ((os_segment*)theLocality) T[mySize];
#else
#if defined(ENV_OSTORE)
  myVector = new (theLocality,OTC_TypeSpec<T>::typespec(), mySize) T[mySize];
#else
  myVector = new T[mySize];
#endif
#endif
  OTCLIB_ASSERT(myVector != 0);

  OTC_CopyActions<T>::copy(myVector,theVector.myVector+theRange.lower(),
   mySize);
}

/* ------------------------------------------------------------------------- */
template<class T>
OTC_Vector<T>::OTC_Vector(
 OTC_Vector<T> const& theVector,
 u_int theStart,
 u_int theLength
)
  : mySize(theLength)
{
  OTCLIB_ENSURE((theLength != 0),
   "OTC_Vector::OTC_Vector() - invalid size");
  OTCLIB_ENSURE((theStart+theLength <= theVector.mySize),
   "OTC_Vector::OTC_Vector() - invalid range");

#if defined(ENV_OSTORE_DML) || defined(ENV_OSTORE)
  OTC_Locality theLocality = OTC_Locality::of(this);
#endif

#if defined(ENV_OSTORE_DML)
  myVector = new ((os_segment*)theLocality) T[mySize];
#else
#if defined(ENV_OSTORE)
  myVector = new (theLocality,OTC_TypeSpec<T>::typespec(),mySize) T[mySize];
#else
  myVector = new T[mySize];
#endif
#endif
  OTCLIB_ASSERT(myVector != 0);

  OTC_CopyActions<T>::copy(myVector,theVector.myVector+theStart,mySize);
}

/* ------------------------------------------------------------------------- */
template<class T>
OTC_Vector<T>::OTC_Vector(T const* theVector, u_int theSize)
  : mySize(theSize)
{
#if defined(ENV_OSTORE_DML) || defined(ENV_OSTORE)
  OTC_Locality theLocality = OTC_Locality::of(this);
#endif

#if defined(ENV_OSTORE_DML)
  myVector = new ((os_segment*)theLocality) T[mySize];
#else
#if defined(ENV_OSTORE)
  myVector = new (theLocality,OTC_TypeSpec<T>::typespec(),mySize) T[mySize];
#else
  myVector = new T[mySize];
#endif
#endif
  OTCLIB_ASSERT(myVector != 0);

  OTC_CopyActions<T>::copy(myVector,theVector,mySize);
}

/* ------------------------------------------------------------------------- */
template<class T>
OTC_Vector<T>& OTC_Vector<T>::operator=(OTC_Vector<T> const& theVector)
{
  if (&theVector != this)
  {
    delete [] myVector;

    mySize = theVector.mySize;

#if defined(ENV_OSTORE_DML) || defined(ENV_OSTORE)
    OTC_Locality theLocality = OTC_Locality::of(this);
#endif

#if defined(ENV_OSTORE_DML)
    myVector = new ((os_segment*)theLocality) T[mySize];
#else
#if defined(ENV_OSTORE)
    myVector = new (theLocality,OTC_TypeSpec<T>::typespec(),mySize) T[mySize];
#else
    myVector = new T[mySize];
#endif
#endif
    OTCLIB_ASSERT(myVector != 0);

    OTC_CopyActions<T>::copy(myVector,theVector.myVector,mySize);
  }

  return *this;
}

/* ------------------------------------------------------------------------- */
template<class T>
void OTC_Vector<T>::resize(u_int theSize)
{
  OTCLIB_ENSURE((theSize != 0),
   "OTC_Vector::resize(u_int) - Invalid size");

  if (theSize == mySize)
    return;

#if defined(ENV_OSTORE_DML) || defined(ENV_OSTORE)
  OTC_Locality theLocality = OTC_Locality::of(this);
#endif

  T* tmpVector;
#if defined(ENV_OSTORE_DML)
  tmpVector = new ((os_segment*)theLocality) T[theSize];
#else
#if defined(ENV_OSTORE)
  tmpVector = new (theLocality,OTC_TypeSpec<T>::typespec(),mySize) T[theSize];
#else
  tmpVector = new T[theSize];
#endif
#endif
  OTCLIB_ASSERT(tmpVector != 0);

  if (theSize <= mySize)
    OTC_CopyActions<T>::copy(tmpVector,myVector,theSize);
  else
    OTC_CopyActions<T>::copy(tmpVector,myVector,mySize);

  delete [] myVector;
  myVector = tmpVector;
  mySize = theSize;
}

/* ------------------------------------------------------------------------- */

#endif /* OTC_COLLCTN_VECTOR_C */
