#ifndef OTC_DEBUG_ASSERT_H
#define OTC_DEBUG_ASSERT_H
/*
// ============================================================================
//
// = LIBRARY
//     OTC
//
// = FILENAME
//     debug/assert.h
// 
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1991 1992 1993 OTC LIMITED
//     Copyright 1994 1995 DUMPLETON SOFTWARE CONSULTING PTY LIMITED
//
// ============================================================================
*/

#ifndef OTC_MISC_MACROS_H
#include <OTC/misc/macros.h>
#endif
#ifndef OTC_DEBUG_STOPHERE_H
#include <OTC/debug/stophere.h>
#endif

/* ------------------------------------------------------------------------- */

#if defined(__cplusplus)

extern "C" void otclib_assert(
 char const* theFile, int theLine, char const* theMessage
);

extern "C" void otclib_assert_w(
 char const* theFile, int theLine, char const* theMessage
);

#else

extern void otclib_assert();
extern void otclib_assert_w();

#endif

#ifdef NDEBUG
#define OTCLIB_ASSERT(ex) ((void)0)
#else
#if defined(__STDCPP__)
#define OTCLIB_ASSERT(ex) \
 ((void)((ex)||(otclib_error_stop_here(), \
 otclib_assert(__FILE__,__LINE__,#ex),0)))
#else
#define OTCLIB_ASSERT(ex) \
 ((void)((ex)||(otclib_error_stop_here(), \
 otclib_assert(__FILE__,__LINE__,"ex"),0)))
#endif
#endif

#ifdef NDEBUG
#define OTCLIB_ASSERT_W(ex) ((void)0)
#else
#if defined(__STDCPP__)
#define OTCLIB_ASSERT_W(ex) \
 ((void)((ex)||(otclib_error_stop_here(), \
 otclib_assert_w(__FILE__,__LINE__,#ex),0)))
#else
#define OTCLIB_ASSERT_W(ex) \
 ((void)((ex)||(otclib_error_stop_here(), \
 otclib_assert_w(__FILE__,__LINE__,"ex"),0)))
#endif
#endif

/* ------------------------------------------------------------------------- */

#endif /* OTC_DEBUG_ASSERT_H */
