#ifndef OTC_DEBUG_ENSURE_H
#define OTC_DEBUG_ENSURE_H
/*
// ============================================================================
//
// = LIBRARY
//     OTC
// 
// = FILENAME
//     debug/ensure.h
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1992 1993 OTC LIMITED
//     Copyright 1994 1995 DUMPLETON SOFTWARE CONSULTING PTY LIMITED
//
// ============================================================================
*/

#ifndef OTC_MISC_MACROS_H
#include <OTC/misc/macros.h>
#endif
#ifndef OTC_DEBUG_STOPHERE_H
#include <OTC/debug/stophere.h>
#endif

/* ------------------------------------------------------------------------- */

#if defined(__cplusplus)

extern "C" void otclib_ensure(
 char const* theFile, int theLine, char const* theCondition,
 char const* theDescription
);

extern "C" void otclib_ensure_w(
 char const* theFile, int theLine, char const* theCondition,
 char const* theDescription
);

#else

extern void otclib_ensure();
extern void otclib_ensure_w();

#endif

#if defined(__STDCPP__)
#define OTCLIB_ENSURE(ex,msg) \
 ((void)((ex)||(otclib_error_stop_here(), \
 otclib_ensure(__FILE__,__LINE__,#ex,msg),0)))
#else
#define OTCLIB_ENSURE(ex,msg) \
 ((void)((ex)||(otclib_error_stop_here(), \
 otclib_ensure(__FILE__,__LINE__,"ex",msg),0)))
#endif

#if defined(__STDCPP__)
#define OTCLIB_ENSURE_W(ex,msg) \
 ((void)((ex)||(otclib_error_stop_here(), \
 otclib_ensure_w(__FILE__,__LINE__,#ex,msg),0)))
#else
#define OTCLIB_ENSURE_W(ex,msg) \
 ((void)((ex)||(otclib_error_stop_here(), \
 otclib_ensure_w(__FILE__,__LINE__,"ex",msg),0)))
#endif

/* ------------------------------------------------------------------------- */

#endif /* OTC_DEBUG_ENSURE_H */
