#ifndef OTC_DEBUG_ERRORS_H
#define OTC_DEBUG_ERRORS_H
/*
// ============================================================================
//
// = LIBRARY
//     OTC
//
// = FILENAME
//     debug/errors.h
//
// = AUTHOR(S)
//     Graham Dumpleton
//
// = COPYRIGHT
//     Copyright 1991 OTC LIMITED
//
// ============================================================================
*/

#ifndef OTC_MISC_MACROS_H
#include <OTC/misc/macros.h>
#endif
#ifndef OTC_DEBUG_STOPHERE_H
#include <OTC/debug/stophere.h>
#endif

/* ------------------------------------------------------------------------- */

/*
// This is equivalent to calling <terminate()> but has C linkage so
// that a program can be terminated from C code.
*/

#if defined(__cplusplus)
extern "C" void OTCLIB_TERMINATE();
#else
extern void OTCLIB_TERMINATE();
#endif

/*
// Function and macro for raising a generic exception.
*/

#if defined(__cplusplus)
extern "C" void otclib_exception(
 char const* theFile, int theLine, char const* theMessage
);
#else
extern void otclib_exception();
#endif

#define OTCLIB_EXCEPTION(msg) \
 otclib_error_stop_here(),otclib_exception(__FILE__,__LINE__,msg)

/* ------------------------------------------------------------------------- */

#endif /* OTC_DEBUG_ERRORS_H */
