#ifndef OTC_DEBUG_LOGBUF_HH
#define OTC_DEBUG_LOGBUF_HH
/*
// ============================================================================
//
// = LIBRARY
//     OTC
// 
// = FILENAME
//     debug/logbuf.hh
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1993 OTC LIMITED
//     Copyright 1994 1995 DUMPLETON SOFTWARE CONSULTING PTY LIMITED
//
// ============================================================================
*/

#ifndef OTC_DEBUG_LOGGER_HH
#include <OTC/debug/logger.hh>
#endif

#include <iostream.h>

#ifdef __GNUG__
#if (__GNUC__ >= 3 || __GNUC_MINOR__ >= 6) || defined(CXX_CYGNUS)
#pragma interface "OTC/debug/logbuf.hh"
#else
#pragma interface
#endif
#endif

/* ------------------------------------------------------------------------- */

class OTC_LogBuf : public streambuf
    // = TITLE
    //	   Streambuf class for use by <OTC_LogStream>.
    //
    // = CLASS TYPE
    //	   Concrete
    //
    // = DESCRIPTION
    //	   <OTC_LogBuf> is used to used to manage the buffer used by
    //	   <OTC_LogStream>, to format messages which are to be sent to the
    //	   logger. Messages are automatically sent to the logger at the set
    //	   priority level, when the stream using this class is flushed,
    //	   or the buffer used in this class is filled.
    //
    // = SEE ALSO
    //	   <OTC_Logger>, <OTC_LogStream>
{
  public:

			~OTC_LogBuf();

    // = INITIALISATION

			OTC_LogBuf(char* theBuffer, int theSize);
				// Initialises the class to manage the buffer
				// being used to format messages by
				// <OTC_LogStream>. <theBuffer> should be the
				// buffer into which messages are going to be
				// formatted. <theSize> should be the size of
				// the buffer you have provided.

    // = LOG LEVEL

    char const*		setTarget(char const* theTarget)
				{
				  char const* tmpTarget = myTarget;
				  myTarget = theTarget;
				  return tmpTarget;
				}
				// Sets the target logger. Returns the
				// previously defined target.

    OTC_LogLevel	setLevel(OTC_LogLevel theLevel)
				{
				  OTC_LogLevel tmpLevel = myLevel;
				  myLevel = theLevel;
				  return tmpLevel;
				}
				// Sets the priority level for messages. When
				// a message is flushed or the buffer is
				// filled, the message will be sent to the
				// logger at priority level <theLevel>.

    // = STREAM FLUSHING

    int			sync();
				// Writes out the message in the buffer
				// to the logger, using the current
				// message priority level.

  protected:

    // These are overrides of virtual functions in the <streambuf> base
    // class.

    streambuf*		setbuf(char* theBuffer, int theSize);

    int			overflow(int c);

    int			underflow();

  private:

			OTC_LogBuf(OTC_LogBuf const&);
				// Do not provide an implementation for this.

    OTC_LogBuf&		operator=(OTC_LogBuf const&);
				// Do not provide an implementation for this.

#if defined(CXX_SUN)

    // Following are provided to eliminate warnings about overloaded
    // virtual functions from Sun C++ 4.0. Hope they do not screw up
    // any other compilers.

    streambuf*		setbuf(unsigned char*, int);
				// Do not provide an implementation for this.

    streambuf*		setbuf(char*, int, int);
				// Do not provide an implementation for this.

#endif

    char const*		myTarget;
				// Target logger.

    OTC_LogLevel	myLevel;
				// Priority level used when messages
				// are sent to the logger.

    char		myBuffer[128];
				// A default buffer.
};

/* ------------------------------------------------------------------------- */

#endif /* OTC_DEBUG_LOGBUF_HH */
