#ifndef OTC_DEBUG_TRCEBUF_HH
#define OTC_DEBUG_TRCEBUF_HH
/*
// ============================================================================
//
// = LIBRARY
//     OTC
// 
// = FILENAME
//     debug/trcebuf.hh
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1994 TELSTRA CORPORATION LIMITED
//     Copyright 1994 1995 DUMPLETON SOFTWARE CONSULTING PTY LIMITED
//
// ============================================================================
*/

#ifndef OTC_OTC_H
#include <OTC/OTC.h>
#endif

#include <iostream.h>

#ifdef __GNUG__
#if (__GNUC__ >= 3 || __GNUC_MINOR__ >= 6) || defined(CXX_CYGNUS)
#pragma interface "OTC/debug/trcebuf.hh"
#else
#pragma interface
#endif
#endif

/* ------------------------------------------------------------------------- */

class OTC_TraceStream;

class OTC_TraceBuf : public streambuf
    // = TITLE
    //     Streambuf which does work of indenting trace information.
    //
    // = CLASS TYPE
    //     Concrete
    //
    // = DESCRIPTION
    //     The <OTC_TraceBuf> does the real work of collecting the
    //     trace information and indenting it when displayed.
    //
    // = SEE ALSO
    //     <OTC_Tracer>
{
  public:

			~OTC_TraceBuf();

    // = INITIALISATION

			OTC_TraceBuf(OTC_TraceStream* theStream);
				// <theStream> should be the instance
				// of <OTC_TraceStream> this class is
				// being held by.

  public:

    int			sync();

  protected:

    streambuf*		setbuf(char* theBuffer, int theSize);

    int			overflow(int c);

    int			underflow();

  private:

			OTC_TraceBuf(OTC_TraceBuf const&);
				// Do not provide an implementation for this.

    OTC_TraceBuf&	operator=(OTC_TraceBuf const&);
				// Do not provide an implementation for this.

#if defined(CXX_SUN)

    // Following are provided to eliminate warnings about overloaded
    // virtual functions from Sun C++ 4.0. Hope they do not screw up
    // any other compilers.

    streambuf*		setbuf(unsigned char*, int);
				// Do not provide an implementation for this.

    streambuf*		setbuf(char*, int, int);
				// Do not provide an implementation for this.

#endif

    OTC_TraceStream*	myStream;
				// Pointer to parent object.

    char		myBuffer[1024];
				// Buffer for collecting output before
				// processing.

    OTC_Boolean		myStartOfLine;
				// Flag indicating if the next character
				// will be the first character on the line.
};

/* ------------------------------------------------------------------------- */

#endif /* OTC_DEBUG_TRCEBUF_HH */
