#ifndef OTC_DEBUG_TRCESTRM_HH
#define OTC_DEBUG_TRCESTRM_HH
/*
// ============================================================================
//
// = LIBRARY
//     OTC
// 
// = FILENAME
//     debug/trcestrm.hh
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1994 TELSTRA CORPORATION LIMITED
//     Copyright 1994 1995 DUMPLETON SOFTWARE CONSULTING PTY LIMITED
//
// ============================================================================
*/

#ifndef OTC_OTC_H
#include <OTC/OTC.h>
#endif

#include <iostream.h>
#include <iomanip.h>

#ifdef __GNUG__
#if (__GNUC__ >= 3 || __GNUC_MINOR__ >= 6) || defined(CXX_CYGNUS)
#pragma interface "OTC/debug/trcestrm.hh"
#else
#pragma interface
#endif
#endif

/* ------------------------------------------------------------------------- */

class OTC_TraceStream : public ostream
    // = TITLE
    //     Trace stream capable of doing indenting.
    //
    // = CLASS TYPE
    //     Concrete
    //
    // = DESCRIPTION
    //     The class <OTC_TraceStream> is a specialised streams class which
    //     provides the ability to indent information passed through the
    //     stream. This ability is used in conjunction with the <OTC_Tracer>
    //     class, to indent trace messages with a marked scope such as a
    //     function.
    //     
    //     Two manipulators are available if explicit indenting of trace
    //     input is required. These are <OTCLIB_TRACEIN> and
    //     <OTCLIB_TRACEOUT>. The first causes indenting to be increased, the
    //     second for it to be decreased.
    //
    // = NOTES
    //     There can only ever be once instance of this class because of
    //     the way the manipulators use static data within this class to
    //     track the indent level. As there is only ever one instance
    //     and static data is set from constructor and then not changed,
    //     there is no thread protection within this class for the static
    //     data.
    //
    // = SEE ALSO
    //     <OTC_Tracer>
{
    friend class	OTC_TraceBuf;

    friend ostream&	OTCLIB_TRACEIN(ostream&);
    friend ostream&	OTCLIB_TRACEOUT(ostream&);

  public:

			~OTC_TraceStream();

			OTC_TraceStream();

    // = QUERY

    long		level();
				// Returns the trace indent level.

  private:

			OTC_TraceStream(OTC_TraceStream const&);
				// Do not provide an implemetation for this.

    OTC_TraceStream&	operator=(OTC_TraceStream const&);
				// Do not provide an implemetation for this.

    static OTC_Boolean	myInitialised;
				// Whether static data has been initalised.

    static int		myObjectIndex;
				// Index into stream data pool where pointer
				// for this instance is stashed.

    static int		myLevelIndex;
				// Index into stream data pool where trace
				// indent level is stashed.

    OTC_TraceBuf*	myBuf;
				// Streambuf which collects data and passes
				// it onto <OTC_Tracer::stream()>.
};

extern ostream& OTCLIB_TRACEIN(ostream&);
extern ostream& OTCLIB_TRACEOUT(ostream&);

/* ------------------------------------------------------------------------- */

#endif /* OTC_DEBUG_TRCESTRM_HH */
