#ifndef OTC_DEBUG_WARNING_H
#define OTC_DEBUG_WARNING_H
/*
// ============================================================================
//
// = LIBRARY
//     OTC
// 
// = FILENAME
//     debug/warning.h
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1992 OTC LIMITED
//
// ============================================================================
*/

#ifndef OTC_MISC_MACROS_H
#include <OTC/misc/macros.h>
#endif
#ifndef OTC_DEBUG_STOPHERE_H
#include <OTC/debug/stophere.h>
#endif

/* ------------------------------------------------------------------------- */

/*
// Function and macro for generating a warning via the logger. Warning
// includes location in code where the macro is used.
*/

#if defined(__cplusplus)
extern "C" void otclib_warning(
 char const* theFile, int theLine, char const* theMessage
);
#else
extern void otclib_warning();
#endif

#define OTCLIB_WARNING(msg) \
 otclib_error_stop_here(), otclib_warning(__FILE__,__LINE__,msg)

/* ------------------------------------------------------------------------- */

#endif /* OTC_DEBUG_WARNING_H */
