#ifndef OTC_DISPATCH_ACTION_HH
#define OTC_DISPATCH_ACTION_HH
/*
// ============================================================================
//
// = LIBRARY
//     OTC
// 
// = FILENAME
//     dispatch/action.hh
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1994 1995 DUMPLETON SOFTWARE CONSULTING PTY LIMITED
//
// ============================================================================
*/

#include <OTC/dispatch/event.hh>
#include <OTC/thread/nrmutex.hh>

#ifdef __GNUG__
#if (__GNUC__ >= 3 || __GNUC_MINOR__ >= 6) || defined(CXX_CYGNUS)
#pragma interface "OTC/dispatch/action.hh"
#else
#pragma interface
#endif
#endif

/* ------------------------------------------------------------------------- */

class OTC_LinkList;

class OTCEV_Action : public OTC_Event
    // = TITLE
    //     Event object to notify that it is time to perform some action.
    //
    // = CLASS TYPE
    //     Concrete
    //
    // = DESCRIPTION
    //     <OTCEV_Action> is a derived version of <OTC_Event> for notifying
    //     agents that it should now perform whatever action that it has been
    //     waiting to perform.
    //     
    // = NOTES
    //     A value of <0> will never be used as an action ID.
    //     
    // = SEE ALSO
    //     <OTC_EVAgent>, <OTC_Event>
{
  public:

			~OTCEV_Action();

    // = CONSTRUCTION

			OTCEV_Action(int theActionId)
			  : myActionId(theActionId)
				{}
				// Creates an event object for notifying an
				// agent that the action given by
				// <theActionId> can now be performed.

    // = QUERY

    int			action() const
				{ return myActionId; }
				// Returns the ID number of the action which
				// should now be performed.

    // = IDENTIFICATION

    void*		type() const;
				// Returns a value that uniquely identifies
				// this type of event.

    static void*	typeId()
				{ return &globTypeId; }
				// Returns a value that uniquely identifies
				// this type of event.

    // = DEBUGGING

    void		dump(ostream& outs) const;
				// Dumps info about the event onto <outs>.

    // = SUBSCRIPTION

    static int		schedule(int theAgentId, int theOptions=0);
				// Registers that the agent with ID number
				// <theAgentId> wishes to perform an action.
				// The identifier for the action is returned.
				// <theOptions> is by default <0>. This value
				// will be passed as the second argument to
				// <schedule()> member function of
				// <OTC_Dispatcher>. Its purpose is dependent
				// on the job queue being used. When
				// <OUX_JobQueue> or <OTK_JobQueue> are being
				// used, a value of <0> or <OUXLIB_IDLE_JOB>
				// indicates the action should be run by the
				// dispatcher when it has nothing else to do.
				// A value of <OUXLIB_PRIORITY_JOB> indicates
				// the action should be run straight away.

    static void		cancel(int theActionId);
				// Cancels the action with ID number
				// <theActionId>.

    static void		cancelAgent(int theAgentId);
				// Cancels any actions which the agent with
				// ID number <theAgentId> is waiting upon.

    static OTC_Boolean	active(int theActionId);
				// Returns <OTCLIB_TRUE> if the action with
				// ID number <theTimerId> has not yet been
				// performed.

  private:

			OTCEV_Action(OTCEV_Action const&);
				// Do not define an implementation for this.

    OTCEV_Action&	operator=(OTCEV_Action const&);
				// Do not define an implementation for this.

    static OTC_NRMutex	_mutex;
				// Lock for threads.

    static int		globActionIdCount;
				// Counter for allocating action ID.

    static OTC_LinkList*	globSubscriptions;
				// List of actions pending.

    static int		globTypeId;
				// Anchor for use as a type identifier.

    int			myActionId;
				// The timer which expired.
};

/* ------------------------------------------------------------------------- */

#endif /* OTC_DISPATCH_ACTION_HH */
