#ifndef OTC_DISPATCH_EVAGENT_HH
#define OTC_DISPATCH_EVAGENT_HH
/*
// ============================================================================
//
// = LIBRARY
//     OTC
// 
// = FILENAME
//     dispatch/evagent.hh
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1993 OTC LIMITED
//     Copyright 1994 1995 DUMPLETON SOFTWARE CONSULTING PTY LIMITED
//
// ============================================================================
*/

#include <OTC/collctn/avltree.hh>
#include <OTC/thread/nrmutex.hh>
#include <OTC/memory/cmmnpool.hh>

#ifdef __GNUG__
#if (__GNUC__ >= 3 || __GNUC_MINOR__ >= 6) || defined(CXX_CYGNUS)
#pragma interface "OTC/dispatch/evagent.hh"
#else
#pragma interface
#endif
#endif

/* ------------------------------------------------------------------------- */

class OTC_Event;

class OTC_EVAgent : private OTC_AVLNode
    // = TITLE
    //	   Base class for objects capable of receiving events.
    //
    // = CLASS TYPE
    //	   Abstract
    //
    // = DESCRIPTION
    //	   <OTC_EVAgent> is a base class for any active object capable of
    //	   receiving events. In essence this class represent a thread
    //	   of control within a process.
    //
    // = SEE ALSO
    //	   <OTC_Event>, <OTC_Dispatcher>
{
    friend		class OTC_Event;

  public:

#if !defined(ENV_NOCOMMONPOOL)
    void*		operator new(size_t theSize)
				{ return OTC_CommonPool::allocate(theSize); }

    void		operator delete(void* theMemory, size_t theSize)
				{ OTC_CommonPool::release(theMemory,theSize); }
#endif

    // = DESTRUCTION

    virtual		~OTC_EVAgent();
				// Removes this agent from the table
				// of active agents.

    // = IDENTIFICATION

    int			id() const
				{ return myId; }
				// Returns the ID number of this agent.

    // = LOOKUP

    static OTC_EVAgent* lookup(int theAgentId);
				// Looks in the table of active agents for
				// the agent with ID number <theAgentId>. If
				// found, a pointer to that agent is
				// returned, otherwise <0> is returned.

  protected:

    // = INITIALISATION

			OTC_EVAgent();
				// Allocates a new agent ID and adds this
				// object to the table of active agents.

    // = EVENT CALLBACK

    virtual void	handle(OTC_Event* theEvent) = 0;
				// Must be redefined in a derived class to
				// handle <theEvent>.

  private:

			OTC_EVAgent(OTC_EVAgent const&) {}
				// Do not define an implementation for this.

    OTC_EVAgent&		operator=(OTC_EVAgent const&);
				// Do not define an implementation for this.

    static OTC_NRMutex	_mutex;
				// Lock for threads.

    static OTC_AVLTree* globAgents;
				// Table of active agents.

    static int		globId;
				// Count for allocating agent ID's.

    int			myId;
				// The id of this agent.
};

/* ------------------------------------------------------------------------- */

#endif /* OTC_DISPATCH_EVAGENT_HH */
