#ifndef OTC_DISPATCH_EVENTJOB_HH
#define OTC_DISPATCH_EVENTJOB_HH
/*
// ============================================================================
//
// = LIBRARY
//     OTC
// 
// = FILENAME
//     dispatch/eventjob.hh
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1993 OTC LIMITED
//     Copyright 1994 DUMPLETON SOFTWARE CONSULTING PTY LIMITED
//
// ============================================================================
*/

#include <OTC/dispatch/job.hh>

#ifdef __GNUG__
#if (__GNUC__ >= 3 || __GNUC_MINOR__ >= 6) || defined(CXX_CYGNUS)
#pragma interface "OTC/dispatch/eventjob.hh"
#else
#pragma interface
#endif
#endif

/* ------------------------------------------------------------------------- */

class OTC_Event;

class OTC_EventJob : public OTC_Job
    // = TITLE
    //     Holds an event, and the ID number of the agent to which the
    //     event is to be delivered.
    //
    // = CLASS TYPE
    //     Concrete
    //
    // = DESCRIPTION
    //     <OTC_EventJob> holds an event, and the ID number of the agent to
    //     which it is to be delivered. Instances of the class are created by
    //     the <OTC_Event> class and scheduled with the dispatcher for later
    //     execution.
    //     
    // = SEE ALSO
    //     <OTC_JobQueue>, <OTC_Dispatcher>, <OTC_EVAgent>, <OTC_Event>
{
  public:

			~OTC_EventJob();

    // = INITIALISATION

			OTC_EventJob(int theAgentId, OTC_Event* theEvent);
				// Creates an object to hold <theEvent> and
				// <theAgentId>, the ID number of the agent
				// to which the event is to be delivered.

    // = QUERY

    int			target() const
				{ return myTarget; }
				// Returns the ID number of the agent to
				// which the event it to be delivered.

    OTC_Event const&	event() const
				{ return *myEvent; }
				// Returns the event.

    // = EXECUTION

    void		execute();
				// Delivers the event to the agent. If the
				// event cannot be delivered, a warning
				// message is displayed using the logger and
				// the event destroyed by calling its
				// <destroy()> member function.

  private:

			OTC_EventJob(OTC_EventJob const&);
				// Do not define an implementation for this.

    OTC_EventJob&	operator=(OTC_EventJob const&);
				// Do not define an implementation for this.

    int			myTarget;
				// The ID number of the agent.

    OTC_Event*		myEvent;
				// The event.
};

/* ------------------------------------------------------------------------- */

#endif /* OTC_DISPATCH_EVENTJOB_HH */
