#ifndef OTC_MEMORY_CLUSTER_HH
#define OTC_MEMORY_CLUSTER_HH
/*
// ============================================================================
//
// = LIBRARY
//     OTC
// 
// = FILENAME
//     memory/cluster.hh
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1994 TELSTRA CORPORATION LIMITED
//     Copyright 1994 1995 DUMPLETON SOFTWARE CONSULTING PTY LIMITED
//
// ============================================================================
*/

#include <OTC/memory/mcobject.hh>
#include <OTC/memory/arena.hh>

#ifdef __GNUG__
#if (__GNUC__ >= 3 || __GNUC_MINOR__ >= 6) || defined(CXX_CYGNUS)
#pragma interface "OTC/memory/cluster.hh"
#else
#pragma interface
#endif
#endif

/* ------------------------------------------------------------------------- */

class OTC_Cluster
    // = TITLE
    //     Pool of objects which are to be deleted at the same time.
    //
    // = CLASS TYPE
    //     Concrete
    //
    // = DESCRIPTION
    //     The <OTC_Cluster> class is a pool of objects which are to
    //     be deleted at the same time. Memory for the objects is
    //     allocated from a memory arena.
    //
    // = NOTES
    //     The <OTC_Cluster> cannot currently be used in a threaded
    //     application where instances of the class would be created
    //     in different threads. This restriction may be dropped in
    //     the future. The <OTC_Cluster> class cannot be allocated in
    //     an ObjectStore database.
    //
    // = EXAMPLE
    // = BEGIN<CODE>
    //     class Foo : public OTC_MCObject { protected: ~Foo(); };
    //
    //     OTC_Cluster cluster;
    //     Foo* foo = new (cluster) Foo;
    // = END<CODE>
    //
    //= SEE ALSO
    //     <OTC_MCObject>, <OTC_Arena>
{
    friend class	OTC_MCObject;

  public:

    // = INITIALISATION

			OTC_Cluster();
				// Creates an empty cluster. Memory
				// allocation used by the <OTC_Arena>
				// class will be as per the default for
				// that class.

			OTC_Cluster(size_t theBlockSize, size_t theSlop=16);
				// Creates an empty cluster. <theBlockSize>
				// and <theSlop> are passed onto the
				// <OTC_Arena>. <theSlop> defaults to <16>.

    // = DESTRUCTION

			~OTC_Cluster();
				// The destructor for each object in the
				// cluster is invoked, and memory released
				// back to the system. The order in which
				// objects are destroyed is such that the
				// most recently allocated object is
				// destroyed first.

  private:

			OTC_Cluster(OTC_Cluster const&);
				// Do not define an implementation for this.

    OTC_Cluster&	operator=(OTC_Cluster const&);
				// Do not define an implementation for this.

    OTC_Arena		myArena;
				// Arena from which memory is allocated.

    OTC_MCObject*	myObjects;
				// Pointer to most recently allocated
				// object in this cluster.
};

/* ------------------------------------------------------------------------- */

#endif /* OTC_MEMORY_CLUSTER_HH */
