#ifndef OTC_MEMORY_PTR_HH
#define OTC_MEMORY_PTR_HH
/*
// ============================================================================
//
// = LIBRARY
//     OTC
// 
// = FILENAME
//     memory/ptr.hh
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1994 1995 DUMPLETON SOFTWARE CONSULTING PTY LIMITED
//
// ============================================================================
*/

#include <OTC/OTC.h>

#ifdef __GNUG__
#if defined(EXPAND_TEMPLATES)
#pragma implementation "OTC/collctn/ptr.hh"
#if (__GNUC__ >= 3 || __GNUC_MINOR__ >= 6) || defined(CXX_CYGNUS)
#pragma interface "OTC/collctn/ptr.hh"
#else
#pragma interface
#endif
#endif
#endif

/* ------------------------------------------------------------------------- */

template<class T>
class OTC_Ptr
    // = TITLE
    //     Pointer which creates object only when required.
    //
    // = CLASS TYPE
    //     Concrete
    //
    // = DESCRIPTION
    //     Designed such that the object being managed is only created
    //     when required. Also deletes the object when pointer class
    //     is destroyed.
    //
    // = NOTES
    //     Argument <T> must be a class object. A builtin type or pointer
    //     cannot be used for <T>.
{
  private:

    T*			_item() const
				{
				  if (myItem == 0)
				  {
#if defined(ENV_OSTORE_DML) || defined(ENV_OSTORE)
				    OTC_Locality theLocality =
				     OTC_Locality::of(this);
#endif
#if defined(ENV_OSTORE_DML)
				    ((OTC_Ptr<T>*)this)->myItem =
				     new ((os_segment*)theLocality) T;
#else
#if defined(ENV_OSTORE)
				    ((OTC_Ptr<T>*)this)->myItem =
				     new (theLocality,T::get_os_typespec()) T;
#else
				    ((OTC_Ptr<T>*)this)->myItem = new T;
#endif
#endif
				    OTCLIB_ASSERT(myItem != 0);
				  }
				  return myItem;
				}
				// Returns the object being pointed at. If
				// the object had not previously been
				// created, it will be created.
  public:

    // = CONSTRUCTION

			OTC_Ptr()
			  : myItem(0) {}
				// Initialises the class to an undefined
				// state. The object is only created when it
				// is first required.

    // = DESTRUCTION

			~OTC_Ptr()
				{ if (myItem != 0) delete myItem; }
				// Destroys the object if it has been
				// created.

    // = ACCESS

    T*			item()
				{ return _item(); }
				// Returns the object being pointed at. If
				// the object had not previously been
				// created, it will be created.

    T const*			item() const
				{ return _item(); }
				// Returns the object being pointed at. If
				// the object had not previously been
				// created, it will be created.

    T*			operator->()
				{ return _item(); }
				// Returns the object being pointed at.

    T const*		operator->() const
				{ return _item(); }
				// Returns the object being pointed at.

			operator T*()
				{ return _item(); }
				// Returns the object being pointed at.

			operator T const*() const
				{ return _item(); }
				// Returns the object being pointed at.

    T&			operator*()
				{ return *_item(); }
				// Returns a reference to the item being
				// pointed at.

    T const&		operator*() const
				{ return *_item(); }
				// Returns a reference to the item being
				// pointed at.

    // = QUERY

    OTC_Boolean		isUndefined() const
				{ return myItem == 0; }
				// Returns <OTCLIB_TRUE> if the object
				// has not yet been created.

  private:

			OTC_Ptr(OTC_Ptr<T> const&)
				{ terminate(); }
				// Do not define an implementation for this.

    OTC_Ptr<T>&		operator=(OTC_Ptr<T> const&)
				{ terminate(); return *this; }
				// Do not define an implementation for this.

    T*			myItem;
				// The item being held.
};

/* ------------------------------------------------------------------------- */

#endif /* OTC_MEMORY_PTR_HH */
