#ifndef OTC_PROGRAM_PROGRAM_HH
#define OTC_PROGRAM_PROGRAM_HH
/*
// ============================================================================
//
// = LIBRARY
//     OTC
//
// = FILENAME
//     program/program.hh
//
// = AUTHOR(S)
//     Graham Dumpleton
//
// = COPYRIGHT
//     Copyright 1991 1992 OTC LIMITED
//     Copyright 1994 1995 DUMPLETON SOFTWARE CONSULTING PTY LIMITED
//
// ============================================================================
*/

#include <OTC/options/options.hh>

#ifdef __GNUG__
#if (__GNUC__ >= 3 || __GNUC_MINOR__ >= 6) || defined(CXX_CYGNUS)
#pragma interface "OTC/program/program.hh"
#else
#pragma interface
#endif
#endif

/* ------------------------------------------------------------------------- */

class OTC_Program
    // = TITLE
    //	   Class to encapsulate information about a programs options.
    //
    // = CLASS TYPE
    //	   Static
    //
    // = DESCRIPTION
    //	   This class should be initialised once using <initialise()> at the
    //	   start of <main()>. Upon doing this it will maintain a copy of the
    //	   name of the program and the options to the program.
    //
    // = NOTES
    //	   It is not safe to use the iterators which can be obtained
    //	   from this class in different threads of a multi threaded
    //	   application. It is also not safe to use the <shift()> and
    //	   <restore()> member functions.
{
  public:

    static void		initialise(int argc, char* argv[]);
				// Initialise the name of the program and its
				// options.

    static OTC_String const&	name();
				// Returns the name of the program.

    static int		numOptions();
				// Returns the number of options supplied to
				// the program. Unlike <argc> this does not
				// include the name of the program in the
				// count. If this class has not been
				// initialised, then <-1> will be returned.

    static OTC_String const&	option(u_int theNum=1);
				// Return the option at position <theNum>.
				// Generates an exception if <theNum> is
				// greater than the number of options.
				// If <theNum> is <0> then the name of the
				// program is returned.

    static OTC_Boolean	optionMatches(u_int theNum, char const* thePattern);
				// Performs a glob style match against the
				// option at position <theNum> and returns
				// <OTCLIB_TRUE> if sucessful.
				// Generates an exception if <theNum> is
				// greater than the number of options.
				// If <theNum> is <0> then the name of the
				// program will be matched against.

    static OTC_Boolean	optionMatches(char const* thePattern)
				{ return optionMatches(1,thePattern); }
				// Performs a glob style match against the
				// the first option and returns <OTCLIB_TRUE>
				// if sucessful. Generates an exception if
				// there are no options. If <theNum> is <0>
				// then the name of the program will be
				// matched against.

    static OTC_Boolean	match(char const* thePattern, u_int theNum=1)
				{ return optionMatches(theNum,thePattern); }
				// Performs a glob style match against the
				// option at position <theNum> and returns
				// <OTCLIB_TRUE> if sucessful.
				// Generates an exception if <theNum> is
				// greater than the number of options.
				// If <theNum> is <0> then the name of the
				// program will be matched against.
				// This function is obsolete, use
				// <optionMatches() instead.

    static OTC_Iterator<OTC_String>	options(
				 OTC_Direction theDirection=OTCLIB_FORWARD
				);
				// Returns an iterator over just the
				// options to the program.

    static OTC_Iterator<OTC_String>	options(
				 u_int theStart,
				 u_int theLength,
				 OTC_Direction theDirection=OTCLIB_FORWARD
				);
				// Returns an iterator over the options
				// in the range commencing at <theStart>
				// and with length <theLength>.

    static OTC_Iterator<OTC_String>	options(
				 OTC_Range const& theRange,
				 OTC_Direction theDirection=OTCLIB_FORWARD
				);
				// Returns an iterator over the options in
				// <theRange>.

    static void		shift(u_int theNum=1);
				// Discard the <theNum> options and shift all
				// other options down one spot. This is
				// analagous to the <shift> operator in shell
				// scripts.

    static void		restore();
				// Restores the set of options after
				// any were discarded using <shift()>.

    // Following functions are currently only available on UNIX like systems.

    static OTC_String const&	basename();
				// Returns the basename part of the
				// program name. ie. it removes the
				// directory information.

    static OTC_String const&	dirname();
				// Returns the directory in which the
				// program was located.

  private:

    static OTC_String*	myName;
				// The name of the program.

    static OTC_Options* myOptions;
				// The options to the program.

    static OTC_String*	myBasename;
				// The basename part of the program name.

    static OTC_String*	myDirname;
				// The directory part of the program name.
};

/* ------------------------------------------------------------------------- */

#endif /* OTC_PROGRAM_PROGRAM_HH */
