#ifndef OTC_REFCNT_CCTRVPTR_C
#define OTC_REFCNT_CCTRVPTR_C
/*
// ============================================================================
//
// = LIBRARY
//     OTC
//
// = FILENAME
//     refcnt/cctrvptr.c
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1991 OTC LIMITED
//     Copyright 1994 1995 DUMPLETON SOFTWARE CONSULTING PTY LIMITED
//
// ============================================================================
*/

/* ------------------------------------------------------------------------- */
template<class T>
OTC_CCtrVecPtr<T>::OTC_CCtrVecPtr()
 : myItem(0), myCount(0)
{
  // Nothing to do.
}

/* ------------------------------------------------------------------------- */
template<class T>
OTC_CCtrVecPtr<T>::OTC_CCtrVecPtr(T const* theItem)
 : myItem(0), myCount(0)
{
  setItem(theItem);
}

/* ------------------------------------------------------------------------- */
template<class T>
OTC_CCtrVecPtr<T>::OTC_CCtrVecPtr(OTC_CCtrVecPtr<T> const& theCtrPtr)
 : myItem(0), myCount(0)
{
  setItem(theCtrPtr);
}

/* ------------------------------------------------------------------------- */
template<class T>
OTC_CCtrVecPtr<T>::~OTC_CCtrVecPtr()
{
  if (myCount != 0)
  {
    myCount->dec();
    if (myCount->count() == 0)
      cleanup();
  }
}

/* ------------------------------------------------------------------------- */
template<class T>
void OTC_CCtrVecPtr<T>::setItem(OTC_CCtrVecPtr<T> const& theCtrPtr)
{
  if (theCtrPtr.myItem == myItem)
    return;

  else
  {
    if (myCount != 0)
    {
      myCount->dec();
      if (myCount->count() == 0)
        cleanup();
    }
    myItem = theCtrPtr.myItem;
    myCount = 0;
    if (myItem != 0)
    {
      myCount = theCtrPtr.myCount;
      myCount->inc();
    }
  }
}

/* ------------------------------------------------------------------------- */
template<class T>
void OTC_CCtrVecPtr<T>::setItem(T const* theItem)
{
  if (myItem == theItem)
    return;

  else
  {
    if (myCount != 0)
    {
      myCount->dec();
      if (myCount->count() == 0)
	cleanup();
    }
    myItem = (T*)theItem;
    myCount = 0;
    if (myItem != 0)
    {
#if defined(ENV_OSTORE_DML) || defined(ENV_OSTORE)
      OTC_Locality theLocality = OTC_Locality::of(this);
#endif

#if defined(ENV_OSTORE_DML)
      myCount = new ((os_segment*)theLocality) OTC_Count;
#else
#if defined(ENV_OSTORE)
      myCount = new (theLocality,OTC_Count::get_os_typespec()) OTC_Count;
#else
      myCount = new OTC_Count;
#endif
#endif
      OTCLIB_ASSERT(myCount != 0);

      myCount->inc();
    }
  }
}

/* ------------------------------------------------------------------------- */
template<class T>
OTC_CCtrVecPtr<T>& OTC_CCtrVecPtr<T>::operator=(
  OTC_CCtrVecPtr<T> const& theCtrPtr
)
{
  setItem(theCtrPtr);
  return *this;
}

/* ------------------------------------------------------------------------- */
template<class T>
OTC_CCtrVecPtr<T>& OTC_CCtrVecPtr<T>::operator=(T const* theItem)
{
  setItem(theItem);
  return *this;
}

/* ------------------------------------------------------------------------- */
template<class T>
u_int OTC_CCtrVecPtr<T>::numRefs() const
{
  if (myItem == 0)
    return 0;

  else
    return myCount->count();
}

/* ------------------------------------------------------------------------- */
template<class T>
void OTC_CCtrVecPtr<T>::cleanup()
{
  if (myCount != 0)
    delete myCount;
  myCount = 0; 
  if (myItem != 0)
    delete [] myItem;
  myItem = 0;
}

/* ------------------------------------------------------------------------- */
template<class T>
T* OTC_CCtrVecPtr<T>::_itemNoNull() const
{
  OTCLIB_ENSURE((myItem != 0),
   "OTC_CCtrVecPtr::_itemNoNull() - No item held");
  return myItem;
}

/* ------------------------------------------------------------------------- */

#endif /* OTC_REFCNT_CCTRVPTR_C */
