#ifndef OTC_REFCNT_COUNT_HH
#define OTC_REFCNT_COUNT_HH
/*
// ============================================================================
//
// = LIBRARY
//     OTC
//
// = FILENAME
//     refcnt/count.hh
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1991 1992 1993 OTC LIMITED
//     Copyright 1994 TELSTRA CORPORATION LIMITED
//     Copyright 1994 DUMPLETON SOFTWARE CONSULTING PTY LIMITED
//
// ============================================================================
*/

#include <OTC/memory/mpobject.hh>

#ifdef __GNUG__
#if (__GNUC__ >= 3 || __GNUC_MINOR__ >= 6) || defined(CXX_CYGNUS)
#pragma interface "OTC/refcnt/count.hh"
#else
#pragma interface
#endif
#endif

/* ------------------------------------------------------------------------- */

class OTC_Count : public OTC_MPObject
    // = TITLE
    //     An integer count.
    //
    // = CLASS TYPE
    //     Concrete
    //
    // = DESCRIPTION
    //     <OTC_Count> contains an integer count. It has a lower
    //     bound of <0> and an upper bound of the largest number which
    //     can be held in a <u_int>. When created, the count is set
    //     to the lower bound of <0>.
    //
    // = NOTES
    //     No check is made against the upper bound, if the count was
    //     incremented that far, it would quitely wrap around to <0>.
{
  public:

#if defined(ENV_OSTORE) && !defined(SCHEMA_GENERATION)
    static os_typespec*	typespec();
    static os_typespec*	get_os_typespec() { return typespec(); }
#endif

			~OTC_Count();

    // = CONSTRUCTION

			OTC_Count()
			  : myCount(0) {}
				// Initialises the count to the lower bound
				// of <0>.

			OTC_Count(OTC_Count const& theCtr)
			  : myCount(theCtr.myCount) {}
				// Initialises the count to the same
				// value as <theCtr>.

    // = ASSIGNMENT

    OTC_Count&		operator=(OTC_Count const& theCtr)
				{ myCount = theCtr.myCount; return *this; }
				// Sets the count to the same value as
				// <theCtr>.

    // = MODIFIERS

    void		inc()
				{ myCount++; }
				// Increments the current count by one.

    void		dec()
				{ if (myCount != 0) myCount--; }
				// Decrements the current count by one. If
				// the counter is already at <0>, the
				// value is unchanged.

    void		set(u_int theCount)
				{ if (myCount != theCount) myCount = theCount; }
				// Sets the count to <theCount>.

    // = QUERY

    u_int		count() const
				{ return myCount; }
				// Returns the current count.

  private:

    u_int		myCount;
				// The current value of the count.

};

/* ------------------------------------------------------------------------- */

#endif /* OTC_REFCNT_COUNT_HH */
