#ifndef OTC_REFCNT_CRESPTR_C
#define OTC_REFCNT_CRESPTR_C
/*
// ============================================================================
//
// = LIBRARY
//     OTC
//
// = FILENAME
//     refcnt/cresptr.c
// 
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1991 OTC LIMITED
//     Copyright 1994 DUMPLETON SOFTWARE CONSULTING PTY LIMITED
//
// ============================================================================
*/

/* ------------------------------------------------------------------------- */
template<class T>
OTC_CResPtr<T>::OTC_CResPtr()
 : myItem(0)
{
  // Nothing to do.
}

/* ------------------------------------------------------------------------- */
template<class T>
OTC_CResPtr<T>::OTC_CResPtr(T const* theItem)
 : myItem(0)
{
  setItem(theItem);
}

/* ------------------------------------------------------------------------- */
template<class T>
OTC_CResPtr<T>::OTC_CResPtr(OTC_CResPtr<T> const& theRP)
 : myItem(0)
{
  setItem(theRP);
}

/* ------------------------------------------------------------------------- */
template<class T>
OTC_CResPtr<T>::~OTC_CResPtr()
{
  if (myItem != 0)
    myItem->unReference();
}

/* ------------------------------------------------------------------------- */
template<class T>
void OTC_CResPtr<T>::setItem(OTC_CResPtr<T> const& theRP)
{
  setItem(theRP.myItem);
}

/* ------------------------------------------------------------------------- */
template<class T>
void OTC_CResPtr<T>::setItem(T const* theItem)
{
  if (myItem == theItem)
    return;

  if (theItem != 0)
    theItem->reference();
  if (myItem != 0)
    myItem->unReference();
  myItem = (T*)theItem;
}

/* ------------------------------------------------------------------------- */
template<class T>
OTC_CResPtr<T>& OTC_CResPtr<T>::operator=(OTC_CResPtr<T> const& theRP)
{
  setItem(theRP);
  return *this;
}

/* ------------------------------------------------------------------------- */
template<class T>
OTC_CResPtr<T>& OTC_CResPtr<T>::operator=(T const* theItem)
{
  setItem(theItem);
  return *this;
}

/* ------------------------------------------------------------------------- */
template<class T>
u_int OTC_CResPtr<T>::numRefs() const
{
  if (myItem == 0)
    return 0;

  else
    return myItem->numRefs();
}

/* ------------------------------------------------------------------------- */
template<class T>
T* OTC_CResPtr<T>::_itemNoNull() const
{
  OTCLIB_ENSURE((myItem != 0),
   "OTC_CResPtr::_itemNoNull() - No item held");
  return myItem;
}

/* ------------------------------------------------------------------------- */

#endif /* OTC_REFCNT_RESPTR_C */
