#ifndef OTC_TEXT_CSTRING_HH
#define OTC_TEXT_CSTRING_HH
/*
// ============================================================================
//
// = LIBRARY
//     OTC
// 
// = FILENAME
//     text/cstring.hh
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1994 TELSTRA CORPORATION LIMITED
//     Copyright 1994 DUMPLETON SOFTWARE CONSULTING PTY LIMITED
//
// ============================================================================
*/

#include <OTC/text/rstring.hh>

#include <string.h>

#ifdef __GNUG__
#if (__GNUC__ >= 3 || __GNUC_MINOR__ >= 6) || defined(CXX_CYGNUS)
#pragma interface "OTC/text/cstring.hh"
#else
#pragma interface
#endif
#endif

/* ------------------------------------------------------------------------- */

class OTC_CString
    // = TITLE
    //     Allows exact length raw strings to be created.
    //
    // = CLASS TYPE
    //     Concrete
    //
    // = DESCRIPTION
    //     <OTC_CString> provides a mechanism for creating raw strings
    //     which use only the amount of memory which is required for
    //     the string. <OTC_CString> should be used when creating
    //     constant strings.
    //
    // = SEE ALSO
    //     <OTC_String>, <OTC_RString>
{
    friend class	OTC_String;

#if defined(ENV_OSTORE) && !defined(SCHEMA_GENERATION)
    static os_typespec* typespec();
    static os_typespec* get_os_typespec() { return typespec(); }
#endif

  public:

    virtual		~OTC_CString();

    // = INITIALISATION

			OTC_CString(char const* theString=0);
				// Creates a copy of <theString>. Only
				// uses enough memory to hold the string.

			OTC_CString(char theChar, u_int theNum=1);
				// Creates a string holding <theNum>
				// instances of <theChar>. Only uses enough
				// memory to hold the string.

			OTC_CString(char const* theString, u_int theNum);
				// Creates a copy of the first <theNum>
				// characters of <theString>. only
				// uses enough memory to hold the string.
				// Raises an exception if <theString> is
				// <0> but <theLength> is greater than <0>.

    // = STREAMS OUTPUT

    friend ostream&	operator<<(ostream& outs, OTC_CString const& theString)
				{ return outs << theString.myData; }
				// Dumps <theString> to the stream <outs>.
				// Width and justification specifications are
				// honoured.

  private:

			OTC_CString(OTC_CString const&);
				// Do not define an implementation for this.

    OTC_CString&	operator=(OTC_CString const&);
				// Do not define an implementation for this.

    OTC_RString		myData;
				// The raw string data.
};

/* ------------------------------------------------------------------------- */

#endif /* OTC_TEXT_CSTRING_HH */
