#ifndef OTC_TEXT_GLOBEX_HH
#define OTC_TEXT_GLOBEX_HH
/*
// ============================================================================
//
// = LIBRARY
//     OTC
//
// = FILENAME
//     text/globex.hh
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1991 OTC LIMITED
//     Copyright 1994 DUMPLETON SOFTWARE CONSULTING PTY LIMITED
//
// ============================================================================
*/

#include <OTC/text/pattern.hh>

#ifdef __GNUG__
#if (__GNUC__ >= 3 || __GNUC_MINOR__ >= 6) || defined(CXX_CYGNUS)
#pragma interface "OTC/text/globex.hh"
#else
#pragma interface
#endif
#endif

/* ------------------------------------------------------------------------- */

class OTC_Globex : public OTC_Pattern
    // = TITLE
    //	   Class to perform shell style globbing on a string.
    //
    // = CLASS TYPE
    //	   Concrete
    //
    // = DESCRIPTION
    //	   This class provides the ability to determine if a string
    //	   matches a particular pattern. The pattern in this case is
    //	   in the form of a shell style globbing pattern.
    //
    // = FORMAT
    //	   In the pattern string:
    //
    // = BEGIN<INDENT>
    // = BEGIN<NOFILL>
    //	   `*' matches any sequence of characters
    //	   `?' matches any character
    //	   [SET] matches any character in the specified set,
    //	   [!SET] or [^SET] matches any character not in the specified set.
    // = END<NOFILL>
    // = END<INDENT>
    //
    //	   Note: the standard regex character '+' (one or more) should by
    //	   simulated by using "?*" which is equivalent here.
    //
    //	   A set is composed of characters or ranges; a range looks like
    //	   character hyphen character (as in 0-9 or A-Z). [0-9a-zA-Z_] is the
    //	   minimal set of characters allowed in the [..] pattern construct.
    //
    //	   To suppress the special syntactic significance of any of
    //	   `[]*?!^-\', and match the character exactly, precede it with a
    //	   `\'.
    //
    // = SOURCE
    //	   This class is based on public domain routines written by
    //	   J. Kercheval (johnk@wrq.com) and posted to alt.sources.
    //
    // = SEE ALSO
    //	   <OTC_Pattern>
{
  public:

#if defined(ENV_OSTORE) && !defined(SCHEMA_GENERATION)
    static os_typespec* typespec();
    static os_typespec* get_os_typespec() { return typespec(); }
#endif

			~OTC_Globex();

    // = INITIALISATION

			OTC_Globex(char const* thePattern);
				// Compiles <thePattern>.

    // = MATCHING

    OTC_Boolean		match(char const* theString);
				// Returns <OTCLIB_TRUE> if the pattern matched
				// against <theString>

    u_int		start() const;
				// Returns the index of the first character
				// of the matched portion of the string.
				// For this class this will always return
				// <0>.

    u_int		length() const;
				// Returns the length of the matched portion
				// of the string. For this class this will
				// always return <0> or the length of the
				// string matched against if the match was
				// successful.

    // = ERRORS

    OTC_Boolean		isValid() const;
				// Returns <OTCLIB_TRUE> if the pattern was
				// valid.

    char const*		error() const;
				// If the pattern was not valid, returns a
				// messages describing what was wrong with
				// the pattern.

  protected:

    int			doMatch(
			 char const* thePattern,
			 char const* theString
			);
				// Performs match.

    int			doMatchStar(
			 char const* thePattern,
			 char const* theString
			);
				// Performs match.

    // = COMPILATION

    void		compile();
				// Compiles the pattern.

  protected:

    // These bogus virtual functions exist here to eliminate warnings
    // from Sun C++ 4.0 compiler.

    u_int		start(u_int) const;

    u_int		length(u_int) const;

  private:

			OTC_Globex(OTC_Globex const&);

    OTC_Globex&		operator=(OTC_Globex const&);

    OTC_Boolean		myValid;
				// <OTCLIB_TRUE> if the pattern is valid.

    char const*		myError;
				// If the pattern is not valid, contains
				// a string describing what is wrong.

    u_int		myLength;
				// Contains the length of the matched
				// portion of the string.
};

/* ------------------------------------------------------------------------- */

#endif /* OTC_TEXT_GLOBEX_HH */
