#ifndef OTC_TEXT_PATTERN_HH
#define OTC_TEXT_PATTERN_HH
/*
// ============================================================================
//
// = LIBRARY
//     OTC
//
// = FILENAME
//     text/pattern.hh
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1991 OTC LIMITED
//     Copyright 1994 DUMPLETON SOFTWARE CONSULTING PTY LIMITED
//
// ============================================================================
*/

#include <OTC/collctn/range.hh>

#ifdef __GNUG__
#if (__GNUC__ >= 3 || __GNUC_MINOR__ >= 6) || defined(CXX_CYGNUS)
#pragma interface "OTC/text/pattern.hh"
#else
#pragma interface
#endif
#endif

/* ------------------------------------------------------------------------- */

class OTC_Pattern
    // = TITLE
    //	   Abstract base class for patterns which will be matched against
    //	   strings.
    //
    // = CLASS TYPE
    //	   Abstract
    //
    // = DESCRIPTION
    //	   This class is used as the base class for various pattern matching
    //	   methods. This allows certain matching routines to be simply
    //	   expressed in terms of a pattern and not a specific type of
    //	   pattern.
{
  public:

    virtual		~OTC_Pattern();

    // = INITIALISATION

			OTC_Pattern(char const* thePattern);
				// <thePattern> is the pattern. This class
				// makes its own copy of <thePattern>.

    // = QEURY

    char const*		pattern() const
				{ return myPattern; }
				// Returns the pattern.

    // = PATTERN OPERATIONS

    virtual OTC_Boolean	match(char const* theString) = 0;
				// Should be redefined in a derived class to
				// return <OTCLIB_TRUE> if the pattern matches
				// <theString>.

    virtual u_int	start() const = 0;
				// Should be redefined in a derived class to
				// return the index to the start of the
				// portion of the string matched.

    virtual u_int	length() const = 0;
				// Returns the length of the portion of the
				// string matched.

    OTC_Range		range() const;
				// Returns a range object representing the
				// portion of the string that matched.

    virtual OTC_Boolean	isValid() const = 0;
				// Should be redefined in a derived class to
				// return <OTCLIB_TRUE> if the pattern was
				// valid.

  protected:

    // These bogus virtual functions exist here to eliminate warnings
    // in derived class from Cygnus C++ compiler.

    virtual u_int	start(u_int) const;

    virtual u_int	length(u_int) const;

  private:

			OTC_Pattern(OTC_Pattern const&);
				// Do not define an implementation for this.

    OTC_Pattern&	operator=(OTC_Pattern const&);
				// Do not define an implementation for this.

    char*		myPattern;
				// The pattern.
};

/* ------------------------------------------------------------------------- */

#endif /* OTC_TEXT_PATTERN_HH */
