#ifndef OTC_THREAD_MUTEX_HH
#define OTC_THREAD_MUTEX_HH
/*
// ============================================================================
//
// = LIBRARY
//     OTC
// 
// = FILENAME
//     thread/mutex.hh
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1995 DUMPLETON SOFTWARE CONSULTING PTY LIMITED
//
// ============================================================================
*/

#ifndef OTC_THREAD_THREAD_HH
#include <OTC/thread/thread.hh>
#endif

#if defined(ENV_THREADS)
#ifdef __GNUG__
#if (__GNUC__ >= 3 || __GNUC_MINOR__ >= 6) || defined(CXX_CYGNUS)
#pragma interface "OTC/thread/mutex.hh"
#else
#pragma interface
#endif
#endif
#endif

/* ------------------------------------------------------------------------- */

class OTC_Mutex
    // = TITLE
    //     A mutex class for when threads are being used.
    //
    // = DESCRIPTION
    //     A mutex class for blocking execution of code by multiple
    //     threads. The class does not prevent a thread from locking
    //     the same mutex a second time. Another thread would be locked
    //     out though. If threads are not available this class doesn't
    //     do anything.
{
  public:

    // = INITIALISATION

			OTC_Mutex();
				// Initialises the mutex.

    // = DESTRUCTION

			~OTC_Mutex();
				// Destroys the mutex.

    // = LOCKING

    void		lock();
				// Attempts to acquire the mutex. Will block
				// this thread if another thread has already
				// acquired the lock. A thread may call this
				// function multiple times. When this occurs,
				// the number of calls to the function must
				// be matched with a corresponding number of
				// calls to the <unlock()> function before the
				// lock is released.

    void		unlock();
				// Releases the lock on this mutex. Will only
				// do this though when the number of calls to
				// this function matches the number of
				// successful calls to <lock()>. It is assumed
				// that the thread from which this function
				// is called is the thread which called
				// <lock()> in the first place.

  private:

			OTC_Mutex(OTC_Mutex const&);
				// Do not define an implementation for this.

    OTC_Mutex&		operator=(OTC_Mutex const&);
				// Do not define an implementation for this.

    int			_valid;
				// Flag indicating if mutex has been
				// initialised. This comes into play where
				// static mutex's are created. Being in
				// static memory this will by default
				// be initialised to zero. The constructor
				// of this class will set this flag to
				// a non zero value. The destructor will
				// set this flag back to zero. If an attempt
				// is made to lock a static mutex before
				// it is initialised, the flag will be
				// zero and the request ignored. Note
				// that it is presumed here that all
				// static initialisation will occur before
				// any threads are created. Since all
				// known compilers so far ensure that
				// all statics are initialised before
				// main this is a reasonable assumption.

#if defined(HAVE_SOLARIS_THREADS)
    int			_nest;
				// Nesting level.

    mutex_t		_mutex;
				// Mutex.

    thread_t		_thread;
				// Thread locking mutex.
#endif

#if defined(HAVE_POSIX_THREADS)
    pthread_mutex_t	_mutex;
				// Mutex.

    pthread_mutexattr_t	_attr;
				// Mutex attributes.
#endif

#if defined(HAVE_VXWORKS_THREADS)
    int			_nest;
				// Nesting level.

    SEM_ID		_mutex;
				// Mutex.

    int			_thread;
				// Thread locking mutex.
#endif

#if defined(HAVE_WIN32_THREADS)
    CRITICAL_SECTION	_mutex;
				// Mutex;

#endif
};

#if !defined(ENV_THREADS)
inline OTC_Mutex::OTC_Mutex() {}
inline OTC_Mutex::~OTC_Mutex() {}
inline void OTC_Mutex::lock() {}
inline void OTC_Mutex::unlock() {}
#endif

/* ------------------------------------------------------------------------- */

#endif /* OTC_THREAD_MUTEX_HH */
