#ifndef OTC_THREAD_NRMUTEX_HH
#define OTC_THREAD_NRMUTEX_HH
/*
// ============================================================================
//
// = LIBRARY
//     OTC
// 
// = FILENAME
//     thread/nrmutex.hh
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1995 DUMPLETON SOFTWARE CONSULTING PTY LIMITED
//
// ============================================================================
*/

#ifndef OTC_THREAD_THREAD_HH
#include <OTC/thread/thread.hh>
#endif

#if defined(ENV_THREADS)
#ifdef __GNUG__
#if (__GNUC__ >= 3 || __GNUC_MINOR__ >= 6) || defined(CXX_CYGNUS)
#pragma interface "OTC/thread/nrmutex.hh"
#else
#pragma interface
#endif
#endif
#endif

/* ------------------------------------------------------------------------- */

class OTC_NRMutex
    // = TITLE
    //	   A mutex class for when threads are being used.
    //
    // = DESCRIPTION
    //	   A mutex class for blocking execution of code by multiple threads.
    //	   The class implements a non recursice mutex. That is, an attempt to
    //	   acquire the mutex by any thread, even the same thread which may
    //	   already have acquired it, will result in the execution of the
    //	   thread being blocked. In other words, do not use this is
    //	   situations where a mutex could be recusively used. In this latter
    //	   case use <OTC_Mutex>.
    //
    // = SEE ALSO
    //	   <OTC_Mutex>
{
  public:

    // = INITIALISATION

			OTC_NRMutex();
				// Initialises the mutex.

    // = DESTRUCTION

			~OTC_NRMutex();
				// Destroys the mutex.

    // = LOCKING

    void		lock();
				// Attempts to acquire the mutex. Will block
				// this thread if the mutex is already locked.

    void		unlock();
				// Releases the lock on this mutex.

  private:

			OTC_NRMutex(OTC_NRMutex const&);
				// Do not define an implementation for this.

    OTC_NRMutex&	operator=(OTC_NRMutex const&);
				// Do not define an implementation for this.

    int			_valid;
				// Flag indicating if mutex has been
				// initialised. This comes into play where
				// static mutex's are created. Being in
				// static memory this will by default
				// be initialised to zero. The constructor
				// of this class will set this flag to
				// a non zero value. The destructor will
				// set this flag back to zero. If an attempt
				// is made to lock a static mutex before
				// it is initialised, the flag will be
				// zero and the request ignored. Note
				// that it is presumed here that all
				// static initialisation will occur before
				// any threads are created. Since all
				// known compilers so far ensure that
				// all statics are initialised before
				// main this is a reasonable assumption.

#if defined(HAVE_SOLARIS_THREADS)
    mutex_t		_mutex;
				// Mutex.
#endif

#if defined(HAVE_POSIX_THREADS)
    pthread_mutex_t	_mutex;
				// Mutex.
#endif

#if defined(HAVE_VXWORKS_THREADS)
    SEM_ID		_mutex;
				// Mutex.
#endif

#if defined(HAVE_WIN32_THREADS)
    HANDLE		_mutex;
				// Mutex;
#endif
};

#if !defined(ENV_THREADS)
inline OTC_NRMutex::OTC_NRMutex() {}
inline OTC_NRMutex::~OTC_NRMutex() {}
inline void OTC_NRMutex::lock() {}
inline void OTC_NRMutex::unlock() {}
#endif

/* ------------------------------------------------------------------------- */

#endif /* OTC_THREAD_NRMUTEX_HH */
