#ifndef OTK_DISPATCH_DISPATCH_HH
#define OTK_DISPATCH_DISPATCH_HH
/*
// ============================================================================
//
// = LIBRARY
//     OTK
// 
// = FILENAME
//     dispatch/dispatch.hh
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1993 TELSTRA CORPORATION LIMITED
//     Copyright 1994 DUMPLETON SOFTWARE CONSULTING PTY LIMITED
//
// ============================================================================
*/

#include <OTC/dispatch/dispatch.hh>
#include <OTC/dispatch/evagent.hh>
#include <OTK/dispatch/jobqueue.hh>

#ifdef __GNUG__
#if (__GNUC__ >= 3 || __GNUC_MINOR__ >= 6) || defined(CXX_CYGNUS)
#pragma interface "OTK/dispatch/dispatch.hh"
#endif
#endif

/* ------------------------------------------------------------------------- */

#if defined(OSE_BUILD) || defined(OTKLIB_DISPATCHERBC)

class OTK_Dispatcher : public OTC_Dispatcher
    // = TITLE
    //     Dispatcher which knows about UNIX events and TK.
    //
    // = CLASS TYPE
    //     Static
    //
    // = DESCRIPTION
    //     <OTK_Dispatcher> is a version of the standard dispatcher which
    //     adds support for UNIX event sources and is also TK aware. These
    //     event sources are, alarms, timers, signals and events on file
    //     descriptors. Jobs registered directly with the standard dispatcher
    //     will only be executed when there are no pending alarms or timers,
    //     and no events pending on file descriptors. These jobs are given
    //     the name of <{idle jobs}>. When the idle jobs registered with the
    //     standard dispatcher are run, they will all be processed once,
    //     before returning to look for pending timers and events on file
    //     descriptors. Signal and alarm events will always preempt idle
    //     jobs. Once the signal and alarm events have been serviced,
    //     returning of idle jobs will commence again, until all the idle
    //     jobs registered at the start of the phase have been returned. Idle
    //     jobs registered while processing current idle jobs, will not be
    //     processed until the next time through the idle job queue.
    //
    // = NOTES
    //     This class is kept for backwards compatability only. To initialise
    //     the dispatcher so that it is aware of UNIX real time events and TK,
    //     use:
    //
    // = BEGIN<CODE>
    //     OTK_JobQueue* queue;
    //     queue = new OTK_JobQueue;
    //     OTC_Dispatcher::initialise(queue);
    //     ...
    //     OTC_Dispatcher::run();
    // = END<CODE>
    //
    // = SEE ALSO
    //     <OTK_JobQueue>, <OUX_JobQueue>
{
   public:

    friend class	OTK_DispatcherDummy;

    // = INITIALISATION

    static void		initialise();
				// Initialises the dispatcher so that it
				// will recognise the UNIX event sources
				// as well as the TK event dispatcher.
				// This function must be called before
				// and idle jobs are registered with the
				// standard dispatcher, and before the
				// standard dispatcher is run or attempts to
				// dispatch a single job using the
				// <dispatch()> function of this class.

  private:

			OTK_Dispatcher();
				// Do not define an implementation.

			OTK_Dispatcher(OTK_Dispatcher const&);
				// Do not define an implementation.

    OTK_Dispatcher&	operator=(OTK_Dispatcher const&);
				// Do not define an implementation.
};

#endif

/* ------------------------------------------------------------------------- */

#endif /* OTK_DISPATCH_DISPATCH_HH */
