#ifndef OUX_DISPATCH_DISPATCH_HH
#define OUX_DISPATCH_DISPATCH_HH
/*
// ============================================================================
//
// = LIBRARY
//     OUX
// 
// = FILENAME
//     dispatch/dispatch.hh
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1993 TELSTRA CORPORATION LIMITED
//     Copyright 1994 DUMPLETON SOFTWARE CONSULTING PTY LIMITED
//
// ============================================================================
*/

#include <OTC/dispatch/dispatch.hh>
#include <OTC/dispatch/evagent.hh>
#include <OUX/dispatch/jobqueue.hh>

#ifdef __GNUG__
#if (__GNUC__ >= 3 || __GNUC_MINOR__ >= 6) || defined(CXX_CYGNUS)
#pragma interface "OUX/dispatch/dispatch.hh"
#endif
#endif

/* ------------------------------------------------------------------------- */

#if defined(OSE_BUILD) || defined(OUXLIB_DISPATCHERBC)

class OUX_Dispatcher : public OTC_Dispatcher
    // = TITLE
    //     Dispatcher which knows about UNIX events.
    //
    // = CLASS TYPE
    //     Static
    //
    // = DESCRIPTION
    //     <OUX_Dispatcher> is a version of the standard dispatcher which
    //     adds support for UNIX event sources. These event sources are,
    //     alarms, timers, signals and events on file descriptors. Jobs
    //     registered directly with the standard dispatcher will only be
    //     executed when there are no pending alarms or timers, and no events
    //     pending on file descriptors. These jobs are given the name of
    //     <{idle jobs}>. When the idle jobs registered with the standard
    //     dispatcher are run, they will all be processed once, before
    //     returning to look for pending timers and events on file
    //     descriptors. Signal and alarm events will always preempt idle
    //     jobs. Once the signal and alarm events have been serviced,
    //     returning of idle jobs will commence again, until all the idle
    //     jobs registered at the start of the phase have been returned. Idle
    //     jobs registered while processing current idle jobs, will
    //     not be processed until the next time through the idle job queue.
    //
    // = NOTES
    //     This class is kept for backwards compatability only. To initialise
    //     the dispatcher so that it is aware of UNIX real time events, use:
    //
    //  = BEGIN<CODE>
    //     OUX_JobQueue* queue = new OUX_JobQueue;
    //     OTC_Dispatcher::initialise(queue);
    //     ...
    //     OTC_Dispatcher::run();
    //  = END<CODE>
    //
    // = SEE ALSO
    //     <OUX_JobQueue>
{
   public:

    // = INITIALISATION

    static void		initialise();
				// Initialises the dispatcher so that it
				// will recognise the UNIX event sources.
				// This function must be called before
				// and idle jobs are registered with the
				// standard dispatcher, and before the
				// standard dispatcher is run or attempts to
				// dispatch a single job using the
				// <dispatch()> function of this class.

  private:

			OUX_Dispatcher();
				// Do not define an implementation.

			OUX_Dispatcher(OUX_Dispatcher const&);
				// Do not define an implementation.

    OUX_Dispatcher&	operator=(OUX_Dispatcher const&);
				// Do not define an implementation.
};

#endif

/* ------------------------------------------------------------------------- */

#endif /* OUX_DISPATCH_DISPATCH_HH */
