## Copyright 1992 1993 OTC LIMITED
## Copyright 1995 DUMPLETON SOFTWARE CONSULTING PTY LIMITED

## Standard targets.

.PHONY : combine
.PHONY : combine.setup
.PHONY : combine.target
.PHONY : combine.always

combine : combine.setup
combine : combine.target
combine : combine.always

combine.setup :: makeit.setup

combine.target :: combine.setup

combine.always :: combine.setup

## Work out which directories we are combining.

ifeq "$(LIBDIRS)" ""
ifneq "$(NONLIBDIRS)" ""
LIBDIRS := $(filter-out $(NONLIBDIRS),$(SUBDIRS))
else
LIBDIRS := $(SUBDIRS)
endif
endif

## Only do something if we have some directories to combine. This module
## isn't mean't to combine object files from the current directory.

ifneq "$(LIBDIRS)" ""

## Adjust variables listing files if not in SRCDIR.

ifneq "$(SRCDIR)" "."

ifneq "$(PTDEFMAP)" ""
override PTDEFMAP := $(firstword $(wildcard $(PTDEFMAP) \
 $(SRCDIR)/$(PTDEFMAP)) $(PTDEFMAP))
endif

ifneq "$(PTDUMMYS)" ""
override PTDUMMYS := $(foreach file,$(PTDUMMYS),$(firstword $(wildcard \
 $(file) $(SRCDIR)/$(file)) $(file)))
endif

ifneq "$(PTMAPS)" ""
override PTMAPS := $(foreach file,$(PTMAPS),$(firstword $(wildcard \
 $(file) $(SRCDIR)/$(file)) $(file)))
endif

endif

## Defaults for how to extract and archive object files
## from/to a library.

RUN-EXTRACT.combine.o = \
 echo "$(AR) xv $${lib}"; \
 $(AR) xv $${lib}

RUN-ARCHIVE.combine.o = \
 echo "$(AR) $(ARFLAGS) $(MK)/lib$(LIBEXT) *$(OBJEXT)"; \
 $(AR) $(ARFLAGS) $(MK)/lib$(LIBEXT) *$(OBJEXT)

RUN-ARCHIVE.combine.sa = \
 echo "$(AR) $(ARFLAGS) $(MK)/lib.sa.$(LIBEXT) *$(OBJEXT)"; \
 $(AR) $(ARFLAGS) $(MK)/lib.sa.$(LIBEXT) *$(OBJEXT)

RUN-ARCHIVE.combine.so = \
 echo "$(AR) $(ARFLAGS) $(MK)/lib.so$(LIBEXT) *$(OBJEXT)"; \
 $(AR) $(ARFLAGS) $(MK)/lib.so$(LIBEXT) *$(OBJEXT)

RUN-LINK.combine.so = \
 echo "$(LD) -o $(MK)/lib.so $(LDPICFLAGS) *$(OBJEXT)"; \
 $(LD) -o $(MK)/lib.so $(LDPICFLAGS) *$(OBJEXT)

## Setup any options for template closure on library.

ifeq "$(_makeit_cxx_supports_cfront_repositories)" "YES"

ifeq "$(filter LC%,$(C++COMPILER))" ""
_combine_defmap := defmap
else
_combine_defmap := defaultmap
endif

ifneq "$(filter closure,$(COMBINE_OPTIONS))" ""
_combine_cfront_closure := YES
endif

ifeq "$(filter minimal_expansion,$(CLOSURE_OPTIONS))" ""
override C++FLAGS += -pta
endif

ifneq "$(filter separate_functions,$(CLOSURE_OPTIONS))" ""
override C++FLAGS += -pts
endif

override PTRDIRS += $(addsuffix /$(MKPTR),$(LIBDIRS))

ifeq "$(filter ignore_repositories,$(MAKEIT_OPTIONS))" ""
ifneq "$(PTRDIRS)" ""
override PTRFLAGS.combine = $(addprefix -ptr,$(PTRDIRS))
endif
endif

RUN-CLOSURE.combine = \
 $(C++) $(C++FLAGS) $(CPPFLAGS) $(LDFLAGS) \
 -ptr$(MKPTR) $(PTRFLAGS.combine) $(MK)/__ptdummy*.cc *$(OBJEXT) $(LDLIBS)

RUN-CLOSURE.combine.so = \
 $(C++) $(C++FLAGS) $(C++PICFLAGS) $(CPPFLAGS) $(LDFLAGS) \
 -ptr$(MKPTR).pic $(PTRFLAGS.combine) $(MK)/__ptdummy*.cc *$(OBJEXT) $(LDLIBS)

endif

ifeq "$(_makeit_cxx_supports_cafe_repositories)" "YES"

ifneq "$(filter closure,$(COMBINE_OPTIONS))" ""
_combine_cafe_closure := YES
endif

override PTRDIRS += $(addsuffix /$(MKPTR),$(LIBDIRS))


ifeq "$(filter ignore_repositories,$(MAKEIT_OPTIONS))" ""
ifneq "$(PTRDIRS)" ""
override PTRFLAGS.combine = $(addprefix -ptr,$(PTRDIRS))
endif
endif

RUN-ARCHIVE.combine.o = \
 $(RM) __0*; \
 echo "$(C++) -xar -ptr$(MKPTR) $(PTRFLAGS.combine) \
 $(C++FLAGS) $(CPPFLAGS) -o $@ *$(OBJEXT)"; \
 $(C++) -xar -ptr$(MKPTR) $(PTRFLAGS.combine) \
 $(C++FLAGS) $(CPPFLAGS) -o $@ *$(OBJEXT)

RUN-LINK.combine.so = \
 echo "$(C++) -G -ptr$(MKPTR).pic \
 $(patsubst -ptr%,-ptr%.pic,$(PTRFLAGS.combine)) \
 $(C++FLAGS) $(CPPFLAGS) -o $@ *$(OBJEXT)" \
 $(LDFLAGS) $(filter-out %.o,$(LDLIBS)); \
 $(C++) -G -ptr$(MKPTR).pic \
 $(patsubst -ptr%,-ptr%.pic,$(PTRFLAGS.combine)) \
 $(C++FLAGS) $(CPPFLAGS) -o $@ *$(OBJEXT) \
 $(LDFLAGS) $(filter-out %.o,$(LDLIBS))

endif

ifneq "$(filter HP3.%,$(C++COMPILER))" ""

RUN-LINK.combine.so = \
 echo "$(C++) -b -ptr$(MKPTR) $(PTRFLAGS.combine) \
 $(C++FLAGS) $(CPPFLAGS) -o $@ *$(OBJEXT)" \
 $(LDFLAGS) $(filter-out %.o,$(LDLIBS)); \
 $(C++) -b -ptr$(MKPTR) $(PTRFLAGS.combine) \
 $(C++FLAGS) $(CPPFLAGS) -o $@ *$(OBJEXT) \
 $(LDFLAGS) $(filter-out %.o,$(LDLIBS))

endif

ifneq "$(filter KAI%,$(C++COMPILER))" ""

RUN-LINK.combine.so = \
 echo "$(C++) -G $(C++FLAGS) $(CPPFLAGS) -o $@ *$(OBJEXT)" \
 $(LDFLAGS) $(filter-out %.o,$(LDLIBS)); \
 $(C++) -G $(C++FLAGS) $(CPPFLAGS) -o $@ *$(OBJEXT) \
 $(LDFLAGS) $(filter-out %.o,$(LDLIBS))

endif

ifneq "$(filter MS%,$(C++COMPILER))" ""

RUN-ARCHIVE.combine.o = \
 echo "$(dir $(C++))LIB -nologo -out:lib$(LIBEXT) *$(OBJEXT)"; \
 $(dir $(C++))LIB -nologo -out:lib$(LIBEXT) *$(OBJEXT); \
 echo "mv lib$(LIBEXT) $(MK)/lib$(LIBEXT)"; \
 mv lib$(LIBEXT) $(MK)/lib$(LIBEXT)

endif  

## Rules for creating libraries.

combine.always :: lib.always

.PHONY : lib.subdirs

lib.subdirs :: lib.setup
	@$(foreach dir,$(LIBDIRS), \
	 $(MAKE) -C $(dir) lib || $(FAILACTION);)

lib.always :: $(MK)/lib$(LIBEXT)

$(addsuffix /$(MK)/lib$(LIBEXT),$(LIBDIRS)) :

$(MK)/lib$(LIBEXT).standin :: $(addsuffix /$(MK)/lib$(LIBEXT),$(LIBDIRS))
	@$(foreach dir,$(LIBDIRS), \
	 $(MAKE) -C $(dir) lib || $(FAILACTION);)
	@touch $@

$(MK)/lib$(LIBEXT) :: $(MK)/lib$(LIBEXT).standin
	$(RM) *$(OBJEXT)
	@for lib in $(addsuffix /$(MK)/lib$(LIBEXT),$(LIBDIRS)); \
	do \
	  if test -f $${lib}; \
	  then \
	    echo $(RM) $(SYMDEFS); \
	    $(RM) $(SYMDEFS); \
	    $(RUN-EXTRACT.combine.o); \
	  fi; \
	done
ifeq "$(_combine_cfront_closure)" "YES"
ifneq "$(PTDEFMAP)" ""
	cp $(PTDEFMAP) $(MKPTR)/$(_combine_defmap)
else
	@if test ! -s $(MKPTR)/$(_combine_defmap); \
	then \
	  echo "@dec ____DUMMY____" > $(MKPTR)/$(_combine_defmap); \
	  echo "<____DUMMY____>" >> $(MKPTR)/$(_combine_defmap); \
	fi
endif
ifneq "$(PTMAPS)" ""
	$(RM) $(MKPTR)/nmap*
	@NUM=1; \
	for i in $(PTMAPS); \
	do \
	  echo "cp $$i $(MKPTR)/nmap$$NUM"; \
	  cp $$i $(MKPTR)/nmap$$NUM; \
	  NUM=`expr $$NUM + 1`; \
	done
endif
	$(RM) $(MK)/__ptdummy*.cc
ifneq "$(PTDUMMYS)" ""
	@NUM=1; \
	for i in $(PTDUMMYS); \
	do \
	  echo "cp $$i $(MK)/__ptdummy$$NUM.cc"; \
	  cp $$i $(MK)/__ptdummy$$NUM.cc; \
	  NUM=`expr $$NUM + 1`; \
	done
endif
	echo "main() { return 0; }" > $(MK)/__ptdummy0.cc
ifneq "$(filter ignore_undefined_symbols,$(CLOSURE_OPTIONS))" ""
	-$(RUN-CLOSURE.combine)
else
	$(RUN-CLOSURE.combine)
endif
	$(RM) a.out __ptdummy*$(OBJEXT)
ifeq "$(_makeit_enable_shared_libraries)" "YES"
ifneq "$(PTDEFMAP)" ""
	cp $(PTDEFMAP) $(MKPTR).pic/$(_combine_defmap)
else
	@if test ! -s $(MKPTR).pic/$(_combine_defmap); \
	then \
	  echo "@dec ____DUMMY____" > $(MKPTR).pic/$(_combine_defmap); \
	  echo "<____DUMMY____>" >> $(MKPTR).pic/$(_combine_defmap); \
	fi
endif
ifneq "$(PTMAPS)" ""
	$(RM) $(MKPTR).pic/nmap*
	@NUM=1; \
	for i in $(PTMAPS); \
	do \
	  echo "cp $$i $(MKPTR).pic/nmap$$NUM"; \
	  cp $$i $(MKPTR).pic/nmap$$NUM; \
	  NUM=`expr $$NUM + 1`; \
	done
endif
ifneq "$(filter ignore_undefined_symbols,$(CLOSURE_OPTIONS))" ""
	-$(RUN-CLOSURE.combine.so)
else
	$(RUN-CLOSURE.combine.so)
endif
	$(RM) a.out __ptdummy*$(OBJEXT)
endif
	@NUM=1; \
	for i in $(MKPTR)/*$(OBJEXT); \
	do \
	  if test -f $$i; \
	  then \
	    echo "ln $$i $(CLOSURE_PREFIX)$$NUM$(OBJEXT)"; \
	    ln $$i $(CLOSURE_PREFIX)$$NUM$(OBJEXT); \
	    NUM=`expr $$NUM + 1`; \
	  fi; \
	done
	$(RM) $(MK)/__ptdummy*.cc
endif
	$(RM) $@
	@$(RUN-ARCHIVE.combine.o)
	$(RM) $(SYMDEFS) *$(OBJEXT)
	$(RANLIB) $@

ifeq "$(_makeit_enable_shared_libraries)" "YES"

combine.always :: shlib.always

.PHONY : shlib.subdirs

shlib.subdirs :: shlib.setup
	@$(foreach dir,$(LIBDIRS), \
	 $(MAKE) -C $(dir) shlib || $(FAILACTION);)

shlib.always :: $(MK)/lib.so

$(addsuffix /$(MK)/lib.so$(LIBEXT),$(LIBDIRS)) :

$(MK)/lib.so.standin :: $(addsuffix /$(MK)/lib.so$(LIBEXT),$(LIBDIRS))
	@$(foreach dir,$(LIBDIRS), \
	 $(MAKE) -C $(dir) shlib || $(FAILACTION);)
	@touch $@

$(MK)/lib.so :: $(MK)/lib.so.standin
	$(RM) *$(OBJEXT) .static
	@for lib in $(addsuffix /$(MK)/lib.sa$(LIBEXT),$(LIBDIRS)); \
	do \
	  if test -f $$lib; \
	  then \
	    echo $(RM) $(SYMDEFS); \
	    $(RM) $(SYMDEFS); \
	    $(RUN-EXTRACT.combine.o); \
	    touch $(MK)/.static; \
	  fi; \
	done
	@if test -f "$(MK)/.static"; \
	then \
	  $(RM) $@; \
	  $(RUN-ARCHIVE.combine.sa); \
	  echo $(RANLIB) $@; \
	  $(RANLIB) $@; \
	  echo "$(RM) $(SYMDEFS) *$(OBJEXT)"; \
	  $(RM) $(SYMDEFS) *$(OBJEXT) $(MK)/.static; \
	fi
	@for lib in $(addsuffix /$(MK)/lib.so$(LIBEXT),$(LIBDIRS)); \
	do \
	  if test -f $$lib; \
	  then \
	    echo $(RM) $(SYMDEFS); \
	    $(RM) $(SYMDEFS); \
	    $(RUN-EXTRACT.combine.o); \
	  fi; \
	done
ifeq "$(_combine_cfront_closure)" "YES"
	@NUM=1; \
	for i in $(MKPTR).pic/*$(OBJEXT); \
	do \
	  if test -f $$i; \
	  then \
	    echo "ln $$i $(CLOSURE_PREFIX)$$NUM$(OBJEXT)"; \
	    ln $$i $(CLOSURE_PREFIX)$$NUM$(OBJEXT); \
	    NUM=`expr $$NUM + 1`; \
	  fi; \
	done
endif
ifneq "$(filter export_shared_objects,$(CLOSURE_OPTIONS))" ""
	$(RM) $(MK)/lib.so$(LIBEXT)
	@$(RUN-ARCHIVE.combine.so)
endif
	@$(RUN-LINK.combine.so)
	$(RM) $(SYMDEFS) *$(OBJEXT)

endif

## Make template repository for shared library objects. Normal repository
## would already have been created elsewhere.

ifeq "$(_combine_cfront_closure)" "YES"
ifeq "$(_makeit_enable_shared_libraries)" "YES"
ifeq "$(_makeit_cxx_supports_cfront_repositories)" "YES"

makeit.setup :: $(MKPTR).pic

$(MKPTR).pic :
	mkdir $@

clean.always ::
	$(RM) $(MKPTR).pic/*
	- rmdir $(MKPTR).pic

endif
endif
endif

endif
