## Copyright 1992 1993 OTC LIMITED
## Copyright 1994 1995 DUMPLETON SOFTWARE CONSULTING PTY LIMITED

## Define symbol identifying the system being used.

override INTERNAL_CPPFLAGS += -DSYS_$(OSE_HOST)

## Define symbol identifying environment being used.

ifneq "$(C++COMPILERENV)" ""
override INTERNAL_CPPFLAGS += -DENV_$(C++COMPILERENV)
endif

## Special check for ODE environment. This environment should not
## cause creation of separate makeit or OSE lib directory, so set
## compiler tag to the now modified C++COMPILER variable.

ifeq "$(C++COMPILERENV)" "ODE"
override C++COMPILERTAG := $(C++COMPILER)
endif

ifeq "$(OO)" ""
override OO := exit 1; *** bad compiler definition ***
endif

## Setup paths of compilers and linkers we are going to use based
## on information in host file. Allow CC and LD to be overriden.
## Always set C++ according to value of C++COMPILER.

override C++ := $($(C++COMPILER)_C++)

ifneq "$(filter default environment,$(origin CC))" ""
override CC := $($(C++COMPILER)_CC)
endif

ifneq "$(filter default environment,$(origin LD))" ""
override LD := $($(C++COMPILER)_LD)
endif

ifeq "$(C++)" ""
override C++ := exit 1; *** bad compiler definition ***
endif

ifeq "$(CC)" ""
override CC := exit 1; *** bad compiler definition ***
endif

ifeq "$(LD)" ""
override LD := exit 1; *** bad compiler definition ***
endif

## Setup location of preprocessor for those compilers which need it.

ifeq "$(origin CPPDIR)" "undefined"
override CPPDIR := $(OSE_HOST_HOME)/lib/$(C++COMPILERTAG)
endif

## Defines properties of various C++ compilers we know about.

# AT&T C++ Version 2.0

ifneq "$(filter ATT2.0,$(C++COMPILER))" ""

_makeit_cxx_valid_compiler_tag := YES

_makeit_cxx_requires_preprocessor := YES
_makeit_cxx_requires_templates := YES
_makeit_cxx_supports_template_file := YES
_makeit_cxx_supports_direct_instantiation := YES

override INTERNAL_C++FLAGS += -DCXX_ATT -DCXX_ATT2_0

export cppC = $(CPPDIR)/cpp

ifeq "$(C++COMPILERENV)" "ODE"
override C++ := $(OO)
endif

endif

# AT&T C++ Version 2.1

ifneq "$(filter ATT2.1,$(C++COMPILER))" ""

_makeit_cxx_valid_compiler_tag := YES

_makeit_cxx_requires_preprocessor := YES
_makeit_cxx_requires_templates := YES
_makeit_cxx_supports_template_file := YES
_makeit_cxx_supports_direct_instantiation := YES

override INTERNAL_C++FLAGS += -DCXX_ATT -DCXX_ATT2_1

ifeq "$(C++COMPILERENV)" "OSTORE"
override INTERNAL_C++FLAGS += -D__cfront21
endif

export cppC = $(CPPDIR)/cpp

ifeq "$(C++COMPILERENV)" "ODE"
override C++ := $(OO)
endif

endif

# AT&T C++ Version 3.0

ifneq "$(filter ATT3.0 ATT3.0.%,$(C++COMPILER))" ""

_makeit_cxx_valid_compiler_tag := YES

_makeit_cxx_requires_preprocessor := $(ATT_C++CPPBROKEN)

_makeit_cxx_supports_cfront_repositories := YES
_makeit_cxx_supports_template_file := YES
_makeit_cxx_supports_direct_instantiation := YES

ifneq "$(filter ATT3.0 ATT3.0.1,$(C++COMPILER))" ""
_makeit_cxx_broken_library_search := YES
endif

override INTERNAL_C++FLAGS += -DCXX_ATT -DCXX_ATT3_0

ifneq "$(filter ATT3.0.%,$(C++COMPILER))" ""
override INTERNAL_C++FLAGS += -DCXX_$(subst .,_,$(C++COMPILER))
endif

ifeq "$(_makeit_cxx_requires_preprocessor)" "YES"
export cppC = $(CPPDIR)/cpp
else
unexport cppC
endif

ifeq "$(C++COMPILERENV)" "OSTORE"
ifneq "$(_makeit_cxx_requires_preprocessor)" "YES"
_makeit_cxx_requires_preprocessor := $(OS_C++CPPBROKEN)
endif
override INTERNAL_C++FLAGS += -D__cfront21 # -D__TEMPLATES__
endif

ifeq "$(C++COMPILERENV)" "VERSANT"
export CXXATT_PATH := $(patsubst %/bin/,%,$(dir $(C++)))
export CXXATT_CC := $(C++)
override C++ := $(VPP_RELEASE)/bin/att.3.0/cxxvatt
ifneq "$(filter production_library,$(VERSANT_OPTIONS))" ""
override LD_RUN_PATH := $(LD_RUN_PATH):$(VPP_RELEASE)/lib/vatt.3.0
override INTERNAL_LDFLAGS += $(LOPT)$(VPP_RELEASE)/lib/vatt.3.0
else
override LD_RUN_PATH := $(LD_RUN_PATH):$(VPP_RELEASE)/lib/vatt.3.0.chk
override INTERNAL_LDFLAGS += $(LOPT)$(VPP_RELEASE)/lib/vatt.3.0.chk
endif
endif

ifeq "$(C++COMPILERENV)" "ODE"
override C++ := $(OO)
endif

endif

# CenterLine C++ Version 1

ifneq "$(filter CL1.%,$(C++COMPILER))" ""

_makeit_cxx_valid_compiler_tag := YES

_makeit_cxx_requires_preprocessor := YES
_makeit_cxx_requires_templates := YES
_makeit_cxx_supports_template_file := YES
_makeit_cxx_supports_direct_instantiation := YES

override INTERNAL_C++FLAGS += -DCXX_CL -DCXX_$(subst .,_,$(C++COMPILER))

export cppC = $(CPPDIR)/cpp

ifeq "$(C++COMPILERENV)" "ODE"
override C++ := $(OO)
endif

endif

# CenterLine C++ Version 2.0/2.1

ifneq "$(filter CL2.0 CL2.0.% CL2.1 CL2.1.%,$(C++COMPILER))" ""

_makeit_cxx_valid_compiler_tag := YES

_makeit_cxx_supports_o_for_objects := YES
_makeit_cxx_supports_cfront_repositories := YES
_makeit_cxx_supports_template_file := YES
_makeit_cxx_supports_direct_instantiation := YES

override INTERNAL_C++FLAGS += -DCXX_CL

ifneq "$(filter CL2.0 CL2.0.%,$(C++COMPILER))" ""
override INTERNAL_C++FLAGS += -DCXX_CL2_0
endif

ifneq "$(filter CL2.1 CL2.1.%,$(C++COMPILER))" ""
override INTERNAL_C++FLAGS += -DCXX_CL2_1
endif

ifneq "$(filter CL2.0.% CL2.1.%,$(C++COMPILER))" ""
override INTERNAL_C++FLAGS += -DCXX_$(subst .,_,$(C++COMPILER))
else
override INTERNAL_C++FLAGS += -DCXX_$(subst .,_,$(C++COMPILER))_0
endif

ifeq "$(C++COMPILERENV)" "OSTORE"
ifneq "$(_makeit_cxx_requires_preprocessor)" "YES"
_makeit_cxx_requires_preprocessor := $(OS_C++CPPBROKEN)
endif
override INTERNAL_C++FLAGS += -D__cfront21 # -D__TEMPLATES__
endif

ifeq "$(C++COMPILERENV)" "VERSANT"
export CXXCENTER_PATH := $(patsubst %/bin/,%,$(dir $(C++)))
export CXXCENTER_CC := $(C++)
override C++ := $(VPP_RELEASE)/bin/center.3.0/cxxcenter
ifneq "$(filter production_library,$(VERSANT_OPTIONS))" ""
override LD_RUN_PATH := $(LD_RUN_PATH):$(VPP_RELEASE)/lib/center.3.0
override INTERNAL_LDFLAGS += $(LOPT)$(VPP_RELEASE)/lib/center.3.0
else
override LD_RUN_PATH := $(LD_RUN_PATH):$(VPP_RELEASE)/lib/center.3.0.chk
override INTERNAL_LDFLAGS += $(LOPT)$(VPP_RELEASE)/lib/center.3.0.chk
endif
endif

ifeq "$(C++COMPILERENV)" "ODE"
override C++ := $(OO)
else
unexport cppC
endif

endif

# DEC C++

ifneq "$(filter DEC1.%,$(C++COMPILER))" ""

_makeit_cxx_valid_compiler_tag := YES

_makeit_cxx_supports_precompiled_templates := YES
_makeit_cxx_supports_direct_instantiation := YES
_makeit_cxx_supports_template_file := YES
_makeit_cxx_supports_ansi_exceptions := YES

override PTFLAGS += -define_templates
override INTERNAL_C++FLAGS += -D__STDCPP__
override INTERNAL_C++FLAGS += -DCXX_DEC -DCXX_$(subst .,_,$(C++COMPILER))

endif

# GNU C++ Version 2.5.X

ifneq "$(filter GNU2.5.%,$(C++COMPILER))" ""

_makeit_cxx_valid_compiler_tag := YES

_makeit_cxx_supports_o_for_objects := YES
_makeit_cxx_supports_template_file := YES
_makeit_cxx_supports_direct_instantiation := YES

override PTFLAGS += -fexternal-templates
override INTERNAL_C++FLAGS += -DCXX_GNU -DCXX_$(subst .,_,$(C++COMPILER))

endif

# GNU/Cygnus C++ Version 2.[67].X

ifneq "$(filter CYG2.6.% CYG2.7.% GNU2.6.% GNU2.7.%,$(C++COMPILER))" ""

_makeit_cxx_valid_compiler_tag := YES

_makeit_cxx_supports_o_for_objects := YES
_makeit_cxx_supports_template_file := YES
_makeit_cxx_supports_direct_instantiation := YES
_makeit_cxx_supports_precompiled_templates := YES

ifneq "$(filter no_implicit_templates,$(MAKEIT_OPTIONS))" ""
override INTERNAL_C++FLAGS += -fno-implicit-templates
else
override PTFLAGS += -fexternal-templates
endif

override INTERNAL_C++FLAGS += -DCXX_GNU
override INTERNAL_C++FLAGS += -DCXX_$(subst .,_,$(C++COMPILER))

ifneq "$(filter CYG2.6.%,$(C++COMPILER))" ""
override INTERNAL_C++FLAGS += -DCXX_CYGNUS
endif

ifneq "$(filter GNU2.7.0,$(C++COMPILER))" ""
# Prohibit inclusion of <std/cstring.h>, it conflicts with
# definitions in <memory.h>. Problem is fixed in GNU 2.7.1.
override INTERNAL_C++FLAGS += -D__CSTRING__
endif

ifneq "$(filter -DHAVE_RTTI,$($(C++COMPILER)_C++FLAGS))" ""
override INTERNAL_C++FLAGS += -frtti
endif

endif

# HP C++

ifneq "$(filter HP%,$(C++COMPILER))" ""

_makeit_cxx_valid_compiler_tag := YES

ifeq "$(C++COMPILERENV)" "EH"
_makeit_cxx_supports_ansi_exceptions := YES
override INTERNAL_C++FLAGS += +eh
endif

_makeit_cxx_supports_o_for_objects := YES
_makeit_cxx_supports_cfront_repositories := YES
# _makeit_cxx_supports_template_file := YES
_makeit_cxx_supports_direct_instantiation := YES

ifneq "$(filter HP3.0,$(C++COMPILER))" ""
_makeit_cxx_broken_library_search := YES
endif

override INTERNAL_C++FLAGS += -DCXX_HP -DCXX_$(subst .,_,$(C++COMPILER))

ifeq "$(C++COMPILERENV)" "OSTORE"
ifneq "$(_makeit_cxx_requires_preprocessor)" "YES"
_makeit_cxx_requires_preprocessor := $(OS_C++CPPBROKEN)
endif
override INTERNAL_C++FLAGS += -D__cfront21 # -D__TEMPLATES__
endif

endif

# KAI C++

ifneq "$(filter KAI%,$(C++COMPILER))" ""

_makeit_cxx_valid_compiler_tag := YES

_makeit_cxx_supports_o_for_objects := YES

ifneq "$(filter -x --exceptions,$($(C++COMPILER)_C++FLAGS))" ""
_makeit_cxx_supports_ansi_exceptions := YES
endif

override INTERNAL_C++FLAGS += -DCXX_KAI -DCXX_$(subst .,_,$(C++COMPILER))

endif

# Lucid C++ 3.2

ifneq "$(filter LC3.2 LC3.2.%,$(C++COMPILER))" ""

_makeit_cxx_valid_compiler_tag := YES

_makeit_cxx_supports_o_for_objects := YES
_makeit_cxx_supports_cfront_repositories := YES
_makeit_cxx_supports_direct_instantiation := YES

override INTERNAL_C++FLAGS += -DCXX_LC -DCXX_LC3_2

ifneq "$(filter LC3.2.%,$(C++COMPILER))" ""
override INTERNAL_C++FLAGS += -DCXX_$(subst .,_,$(C++COMPILER))
endif

ifneq "$(filter energize,$(LUCID_OPTIONS))" ""
override INTERNAL_C++FLAGS += -Xez
override AR := $(dir $(C++))energize_ar -Xez
else
ifneq "$(filter precompiled_headers,$(LUCID_OPTIONS))" ""
override INTERNAL_C++FLAGS += -XHP
endif
endif

# ifeq "$(C++COMPILERENV)" "OSTORE"
# ifneq "$(_makeit_cxx_requires_preprocessor)" "YES"
# _makeit_cxx_requires_preprocessor := $(OS_C++CPPBROKEN)
# endif
# override INTERNAL_C++FLAGS += -D__cfront21 # -D__TEMPLATES__
# endif

endif

# Micro$oft C++ 2.0 (Windows/NT)

ifneq "$(filter MS2.%,$(C++COMPILER))" ""

_makeit_cxx_valid_compiler_tag := YES

_makeit_cxx_supports_precompiled_templates := YES
_makeit_cxx_supports_ansi_exceptions := YES

override INTERNAL_CPPFLAGS += -I$(dir $(C++))../INCLUDE

override INTERNAL_C++FLAGS += -DCXX_MS -DCXX_MS2_0
override INTERNAL_C++FLAGS += -DWIN32 -DEXPAND_TEMPLATES

override INTERNAL_LDFLAGS += -L$(dir $(C++))../LIB

override SYSTEM_LDLIBS += WSOCK32.LIB

ifneq "$(filter -DHAVE_WIN32_THREADS,$($(C++COMPILER)_CPPFLAGS))" ""
override INTERNAL_CPPFLAGS += -D_MT
override SYSTEM_LDFLAGS += /NODEFAULTLIB:LIBC.LIB
override SYSTEM_LDLIBS += LIBCMT.LIB
endif

endif

# Novell C++

ifneq "$(filter NOV%,$(C++COMPILER))" ""

_makeit_cxx_valid_compiler_tag := YES

_makeit_combine_compile_and_link := YES

override INTERNAL_C++FLAGS += -Tauto
override INTERNAL_C++FLAGS += -DCXX_NOV -DCXX_$(subst .,_,$(C++COMPILER))

endif

# ObjectStore C++

# NOTE: more stuff for ObjectStore in start.mk to enable OSTORE env
# if +OSTD option used. Can't have it here as C++FLAGS wouldn't have
# been set yet.

ifneq "$(filter OS%,$(C++COMPILER))" ""

_makeit_cxx_valid_compiler_tag := YES

_makeit_cxx_requires_preprocessor := $(OS_C++CPPBROKEN)

_makeit_cxx_supports_o_for_objects := YES
_makeit_cxx_supports_template_file := YES
_makeit_cxx_supports_precompiled_templates := YES
_makeit_cxx_supports_direct_instantiation := YES

_makeit_cleanup_objectstore := YES

override INTERNAL_C++FLAGS += -DCXX_OS -DCXX_$(subst .,_,$(C++COMPILER))

ifeq "$(C++COMPILERENV)" "OSTORE"
override INTERNAL_C++FLAGS += +OSTD -D__TEMPLATES__
endif

ifeq "$(_makeit_cxx_requires_preprocessor)" "YES"
export oscppC = $(CPPDIR)/cpp
export OS_OSSG_CPP = $(CPPDIR)/cpp
else
unexport oscppC
endif

endif

# SGI C++ (CFRONT Port)

ifneq "$(filter SG3.%,$(C++COMPILER))" ""

_makeit_cxx_valid_compiler_tag := YES

# _makeit_cxx_supports_o_for_objects := YES
_makeit_cxx_supports_cfront_repositories := YES
_makeit_cxx_supports_template_file := YES
_makeit_cxx_supports_direct_instantiation := YES

override INTERNAL_C++FLAGS += -DCXX_SG
override INTERNAL_C++FLAGS += -DCXX_$(subst .,_,$(C++COMPILER))

ifeq "$(C++COMPILERENV)" "VERSANT"
export CXXSGI_PATH := $(dir $(C++))
export CXXSGI_CC := $(C++)
override C++ := $(VPP_RELEASE)/bin/sgi.3.0/cxxsgi
ifneq "$(filter production_library,$(VERSANT_OPTIONS))" ""
override INTERNAL_LDFLAGS += $(LOPT)$(VPP_RELEASE)/lib/sgi.3.0
else
override INTERNAL_LDFLAGS += $(LOPT)$(VPP_RELEASE)/lib/sgi.3.0.chk
endif
endif

endif

# SGI C++ (EDG Front End)

ifneq "$(filter SG4.%,$(C++COMPILER))" ""

_makeit_cxx_valid_compiler_tag := YES

_makeit_cxx_supports_o_for_objects := YES

override INTERNAL_C++FLAGS += -ptused -prelink
override INTERNAL_C++FLAGS += -DCXX_SG -DCXX_$(subst .,_,$(C++COMPILER))

endif

# SGI DELTA C++ (DELTA C++ / EDG Front End)

ifneq "$(filter SGD%,$(C++COMPILER))" ""

_makeit_cxx_valid_compiler_tag := YES

_makeit_cxx_supports_o_for_objects := YES

override INTERNAL_C++FLAGS += -ptused -prelink
override INTERNAL_C++FLAGS += -DCXX_SGD -DCXX_$(subst .,_,$(C++COMPILER))

endif

# Sun C++ Version 2.1

ifeq ($(C++COMPILER),SUN2.1)

_makeit_cxx_valid_compiler_tag := YES

_makeit_cxx_supports_o_for_objects := YES
_makeit_cxx_requires_preprocessor := YES
_makeit_cxx_requires_templates := YES
_makeit_cxx_supports_template_file := YES
_makeit_cxx_supports_direct_instantiation := YES

override INTERNAL_C++FLAGS += -DCXX_SUN -DCXX_SUN2_1

ifeq "$(C++COMPILERENV)" "ODE"
export cppC = $(CPPDIR)/cpp
else
override INTERNAL_C++FLAGS += -Qpath $(CPPDIR)
endif

ifeq "$(C++COMPILERENV)" "OSTORE"
override INTERNAL_C++FLAGS += -D__cfront21
endif

ifeq "$(C++COMPILERENV)" "VERSANT"
ifneq "$(filter %/SC1.0/CC,$(C++))" ""
export CXXSUN_PATH := $(dir $(C++))
else
export CXXSUN_PATH := $(dir $(C++))SC1.0
endif
export CXXSUN_CC := $(C++)
override C++ := $(VPP_RELEASE)/bin/cxxsun
ifneq "$(filter production_library,$(VERSANT_OPTIONS))" ""
override INTERNAL_LDFLAGS += $(LOPT)$(VPP_RELEASE)/lib/sun.2.1
else
override INTERNAL_LDFLAGS += $(LOPT)$(VPP_RELEASE)/lib/sun.2.1.chk
endif
endif

ifeq "$(C++COMPILERENV)" "ODE"
override C++ := $(OO)
endif

endif

# Sun C++ Version 3.0

ifneq "$(filter SUN3.0 SUN3.0.%,$(C++COMPILER))" ""

_makeit_cxx_valid_compiler_tag := YES

_makeit_cxx_supports_o_for_objects := YES
_makeit_cxx_supports_cfront_repositories := YES
_makeit_cxx_supports_template_file := YES
_makeit_cxx_supports_direct_instantiation := YES

ifneq "$(filter SUN3.0 SUN3.0.1,$(C++COMPILER))" ""
_makeit_cxx_broken_library_search := YES
endif

override INTERNAL_C++FLAGS += -DCXX_SUN -DCXX_SUN3_0

ifneq "$(filter SUN3.0.%,$(C++COMPILER))" ""
override INTERNAL_C++FLAGS += -DCXX_$(subst .,_,$(C++COMPILER))
endif

ifeq "$(C++COMPILERENV)" "OSTORE"
ifneq "$(_makeit_cxx_requires_preprocessor)" "YES"
_makeit_cxx_requires_preprocessor := $(OS_C++CPPBROKEN)
endif
override INTERNAL_C++FLAGS += -D__cfront21 # -D__TEMPLATES__
endif

ifeq "$(C++COMPILERENV)" "VERSANT"
ifneq "$(filter %/SC2.0.1/CC %/SC2.0.1patch/CC,$(C++))" ""
export CXXSUN_PATH := $(dir $(C++))
else
export CXXSUN_PATH := \
 $(firstword $(wildcard $(dir $(C++))SC2.0.1patch $(dir $(C++))SC2.0.1))
endif
export CXXSUN_CC := $(C++)
override C++ := $(VPP_RELEASE)/bin/sun.3.0/cxxsun
ifneq "$(filter production_library,$(VERSANT_OPTIONS))" ""
override LD_RUN_PATH := $(LD_RUN_PATH):$(VPP_RELEASE)/lib/sun.3.0
override INTERNAL_LDFLAGS += $(LOPT)$(VPP_RELEASE)/lib/sun.3.0
else
override LD_RUN_PATH := $(LD_RUN_PATH):$(VPP_RELEASE)/lib/sun.3.0.chk
override INTERNAL_LDFLAGS += $(LOPT)$(VPP_RELEASE)/lib/sun.3.0.chk
endif
endif

ifeq "$(C++COMPILERENV)" "ODE"
override C++ := $(OO)
endif

endif

# Sun C++ Version 4.0

ifneq "$(filter SUN4.0 SUN4.0.%,$(C++COMPILER))" ""

_makeit_cxx_valid_compiler_tag := YES

_makeit_cxx_supports_o_for_objects := YES
_makeit_cxx_supports_cafe_repositories := YES
_makeit_cxx_supports_ansi_exceptions := YES

ifeq "$(C++COMPILERENV)" "VERSANT"
override C++COMPILERTAG := $(C++COMPILER)
ifneq "$(filter production_library,$(VERSANT_OPTIONS))" ""
override LD_RUN_PATH := $(LD_RUN_PATH):$(VPP_RELEASE)/lib/sun.4.0
override INTERNAL_LDFLAGS += $(LOPT)$(VPP_RELEASE)/lib/sun.4.0
else
override LD_RUN_PATH := $(LD_RUN_PATH):$(VPP_RELEASE)/lib/sun.4.0.chk
override INTERNAL_LDFLAGS += $(LOPT)$(VPP_RELEASE)/lib/sun.4.0.chk
endif
else
override INTERNAL_C++FLAGS += -DCXX_SUN -DCXX_SUN4_0
endif

ifeq "$(C++COMPILERENV)" "OSTORE"
ifeq "$(filter 1% 2% 3%,$(OS_VERSION))" ""
override INTERNAL_C++FLAGS += -vdelx
endif
endif

endif

# Sun C++ Version 4.1

ifneq "$(filter SUN4.1 SUN4.1.%,$(C++COMPILER))" ""

_makeit_cxx_valid_compiler_tag := YES

_makeit_cxx_supports_o_for_objects := YES
_makeit_cxx_supports_cafe_repositories := YES
_makeit_cxx_supports_ansi_exceptions := YES

ifeq "$(C++COMPILERENV)" "VERSANT"
override C++COMPILERTAG := $(C++COMPILER)
ifneq "$(filter production_library,$(VERSANT_OPTIONS))" ""
override LD_RUN_PATH := $(LD_RUN_PATH):$(VPP_RELEASE)/lib/sun.4.1
override INTERNAL_LDFLAGS += $(LOPT)$(VPP_RELEASE)/lib/sun.4.1
else
override LD_RUN_PATH := $(LD_RUN_PATH):$(VPP_RELEASE)/lib/sun.4.1.chk
override INTERNAL_LDFLAGS += $(LOPT)$(VPP_RELEASE)/lib/sun.4.1.chk
endif
else
override INTERNAL_C++FLAGS += -DCXX_SUN -DCXX_SUN4_1
endif

ifeq "$(C++COMPILERENV)" "OSTORE"
ifeq "$(filter 1% 2% 3%,$(OS_VERSION))" ""
ifeq "$(OSE_HOST)" "SPARC_SOL2"
override INTERNAL_C++FLAGS += -vdelx
endif
endif
endif

endif

# XL C++ Version 1

ifneq "$(filter XL%,$(C++COMPILER))" ""

_makeit_cxx_valid_compiler_tag := YES

_makeit_cxx_supports_ansi_exceptions := YES
_makeit_cxx_supports_precompiled_templates := YES
_makeit_cxx_supports_xl_repositories := YES
# _makeit_cxx_supports_direct_instantiation := YES

override INTERNAL_C++FLAGS += -+ -qlanglvl=compat
override INTERNAL_C++FLAGS += -DCXX_XL -DCXX_$(subst .,_,$(C++COMPILER))

# ifeq "$(C++COMPILERENV)" "VERSANT"
# # This may not be correct.
# export CXXXLC_PATH := $(dir $(C++))
# export CXXXLC_CC := $(C++)
# override C++ := $(VPP_RELEASE)/bin/xlc.3.0/cxxxlc
# ifneq "$(filter production_library,$(VERSANT_OPTIONS))" ""
# override INTERNAL_LDFLAGS += $(LOPT)$(VPP_RELEASE)/lib/xlc.3.0
# else
# override INTERNAL_LDFLAGS += $(LOPT)$(VPP_RELEASE)/lib/xlc.3.0.chk
# endif
# endif

endif

##
## Check if valid C++ compiler tag was provided.
##

ifneq "$(_makeit_cxx_valid_compiler_tag)" "YES"

override C++ := exit 1; *** invalid compiler tag ***
override CC := exit 1; *** invalid compiler tag ***
override LD := exit 1; *** invalid compiler tag ***

endif

##
## Check for special environments.
##

ifeq "$(C++COMPILERENV)" "OSTORE"
_makeit_cleanup_objectstore := YES
ifneq "$(filter X86_NT%,$(OSE_HOST))" ""
override OS_ROOTDIR := $(subst \,/,$(OS_ROOTDIR))
endif
override INTERNAL_CPPFLAGS += -I$(OS_ROOTDIR)/include
override LD_RUN_PATH := $(LD_RUN_PATH):$(OS_ROOTDIR)/lib
override INTERNAL_LDFLAGS += $(LOPT)$(OS_ROOTDIR)/lib
endif

ifeq "$(C++COMPILERENV)" "VERSANT"
override INTERNAL_CPPFLAGS += -I$(VPP_RELEASE)/h
override LD_RUN_PATH := $(LD_RUN_PATH):$(VPP_RELEASE)/lib
override INTERNAL_LDFLAGS += $(LOPT)$(VPP_RELEASE)/lib
override INTERNAL_LDLIBS += -lcxxcls
ifneq "$(filter dual_processes,$(VERSANT_OPTIONS))" ""
override INTERNAL_LDLIBS += -loscfe
else
override INTERNAL_LDLIBS += -losc
endif
endif

##
## Check if we are using ObjectStore with non ObjectStore compiler.
##

ifeq "$(C++COMPILERENV)" "OSTORE"
ifeq "$(filter OS1.% OS2.%,$(C++COMPILER))" ""
ifeq "$(_makeit_cxx_requires_preprocessor)" "YES"
export oscppC = $(CPPDIR)/cpp
else
unexport cppC
endif
endif
endif

##
## Check if compiler has patch for library search problem. This applies
## to Sun C++ 3.0/3.0.1 and AT&T 3.0/3.0.1.
##

ifeq "$(_makeit_cxx_broken_library_search)" "YES"
ifeq "$($(C++COMPILER)_C++LIBSEARCHPATCH)" "YES"
_makeit_cxx_broken_library_search := NO
endif
endif

## OSECC wrapper. Must be able to find OSE include files.

ifeq "$(_makeit_cxx_requires_wrapper)" "YES"
ifneq "$(OSE_BUILD)" "YES"
ifeq "$(filter ose,$(MODULES))" ""
override INTERNAL_CPPFLAGS += -I$(OSE_HOME)/include
endif
endif
endif

## Define __OSE_TEMPLATES__ in the makefile if using the template
## preprocessor.

ifeq "$(_makeit_cxx_requires_templates)" "YES"
_makeit_cxx_supports_precompiled_templates := YES
__OSE_TEMPLATES__ := YES
endif

## Define HAVE_EXCEPTIONS if C++ compiler has ANSI exceptions. Note, they
## must include terminate() and set_terminate() functions.

ifeq "$(_makeit_cxx_supports_ansi_exceptions)" "YES"
override INTERNAL_C++FLAGS += -DHAVE_EXCEPTIONS
endif
