## Copyright 1992 1993 OTC LIMITED
## Copyright 1994 1995 DUMPLETON SOFTWARE CONSULTING PTY LIMITED

## Look in host makeit directory for OSE-CONFIG.h header file.

override INTERNAL_CPPFLAGS += -I$(OSE_HOST_MAKEIT)

## Make sure we use makeit for sub makes.

ifneq "$(MAKEIT)" ""
MAKE_COMMAND := $(MAKEIT)
endif

## Define the fail action for a sub make. If -k passed on command line
## want to keep going.

ifneq "$(findstring k,$(filter -%,$(filter-out --%,$(MAKEFLAGS))))" ""
FAILACTION := true
else
FAILACTION := exit 1
endif

## Convert OSE_MAKEIT to absolute pathname if necessary.

# Do not know if this is still necessary.
# Would only have been necessary during
# installation if at all. Need for it has
# probably gone away now that variables
# are not exported into environment when
# running a make in a subdirectory.

# ifeq "$(filter /%,$(OSE_MAKEIT))" ""
# override OSE_MAKEIT := $(shell pwd)/$(OSE_MAKEIT)
# endif

## Work out name of makeit subdirectory.

MKTAG := $(strip $(MKTAG))

ifeq "$(MKTAG)" ""
override MKTAG := $(OSE_HOST)
endif

override CPU := $(MKTAG)

ifneq "$(MKTAG)" ""
override MK := $(MKTAG)
else
override MK := MK
endif

override WSPREFIX :=

ifneq "$(SRCDIR)" ""
ifneq "$(SRCDIR)" "."
override WSPREFIX := WS-
endif
endif

override MK := $(MK)_$(VARIANT)

ifneq "$(filter encode_compiler_name,$(MAKEIT_OPTIONS))" ""
override MK := $(MK).$(subst .,_,$(C++COMPILERTAG))
endif

ifneq "$(WSPREFIX)" ""
override MK := $(WSPREFIX)$(MK)
endif

ifneq "$(MKPREFIX)" ""
override MK := $(MKPREFIX)$(MK)
endif

ifneq "$(MKSUFFIX)" ""
override MK := $(MK)$(MKSUFFIX)
endif

ifneq "$(PTRDIR)" ""
override MKPTR := $(PTRDIR)
endif

ifeq "$(MKPTR)" ""
override MKPTR := $(MK).ptr
endif

## Calculate SRCDIR, source files etc.

override SRCDIR := $(strip $(SRCDIR))

ifeq "$(SRCDIR)" ""
override SRCDIR := .
endif

# Prevent SRCDIR being passed on command line to sub makes. While we
# are doing this, do the same thing for SUBDIRS.

override MAKEOVERRIDES := $(filter-out SUBDIRS=% SRCDIR=%,$(MAKEOVERRIDES))

# Work out set of source files. If compilation in separate directory, also
# merge in source files in that directory.

override SRCFILES := $(notdir $(wildcard $(SRCDIR)/*))

ifneq "$(SRCDIR)" "."
override SRCFILES += $(wildcard *)
override SRCFILES := $(sort $(SRCFILES))
endif

# Check for illegal files. These are files containing a '%' or '#'
# in their name. Take them out and give a diagnostic warning.

_makeit_illegal_files :=
_makeit_illegal_files += $(filter-out $(subst %,,$(SRCFILES)),$(SRCFILES))
_makeit_illegal_files += $(filter-out $(subst \#,,$(SRCFILES)),$(SRCFILES))
_makeit_illegal_files := $(sort $(_makeit_illegal_files))

ifneq "$(_makeit_illegal_files)" ""

override SRCFILES := $(filter $(subst %,,$(SRCFILES)),$(SRCFILES))
override SRCFILES := $(filter $(subst \#,,$(SRCFILES)),$(SRCFILES))

makeit.setup ::
	@echo
	@echo "The following files contained illegal"
	@echo "characters in their names:"
	@echo
	@echo "  $(_makeit_illegal_files)"
	@echo
	@echo "These files will be ignored."
	@echo

# override _makeit_dummy := $(shell echo 1>&2)
# override _makeit_dummy := \
#  $(shell echo "The following files contained illegal" 1>&2)
# override _makeit_dummy := \
#  $(shell echo "characters in their names:" 1>&2)
# override _makeit_dummy := $(shell echo 1>&2)
# override _makeit_dummy := $(shell echo "  $(_makeit_illegal_files)" 1>&2)
# override _makeit_dummy := $(shell echo 1>&2)
# override _makeit_dummy := \
#  $(shell echo "These files will be ignored." 1>&2)
# override _makeit_dummy := $(shell echo 1>&2)

endif

# Define suffixes for files if undefined.

ifeq "$(origin BINEXT)" "undefined"
override BINEXT :=
endif

ifeq "$(origin CMDEXT)" "undefined"
override CMDEXT :=
endif

ifeq "$(origin LIBEXT)" "undefined"
override LIBEXT := .a
endif

ifeq "$(origin OBJEXT)" "undefined"
override OBJEXT := .o
endif

ifeq "$(origin SOBJEXT)" "undefined"
override SOBJEXT := .so
endif
