## Copyright 1993 OTC LIMITED
## Copyright 1995 DUMPLETON SOFTWARE CONSULTING PTY LIMITED

all :

.PHONY : makeit.setup

makeit.setup ::

depend.setup :: makeit.setup
all.setup :: makeit.setup
lib.setup :: makeit.setup
shlib.setup :: makeit.setup
programs.setup :: makeit.setup
mostlyclean.setup :: makeit.setup
clean.setup :: makeit.setup
distclean.setup :: makeit.setup
realclean.setup :: makeit.setup

# Following is to handle version 3.X makeit being run but with OSE_VERSION
# defined to 4.X or later.

ifeq "$(OSE_HOST_MAKEIT)" ""
ifneq "$(OSE_HOST)" ""

OSE_HOST_MAKEIT = $(OSE_ROOT)/$(OSE_VERSION)/$(OSE_HOST)/include/makeit

else

override OSE_MAKEIT :=

# override _makeit_dummy := $(shell echo 1>&2)
# override _makeit_dummy := $(shell echo \
#  "To use version 4.0 or later, the OSE_HOST variable must be set." 1>&2)
# override _makeit_dummy := $(shell echo 1>&2)

endif
endif

# Add default search directory for modules.

override MODULEPATH += $(OSE_MAKEIT)

# Use default set of modules if none defined.

override COREMODULES += ose
override COREMODULES += tcl xwindows
override COREMODULES += yacc lex rpcgen
override COREMODULES += cc cpp cxx C c-cc
override COREMODULES += c
override COREMODULES += sh
override COREMODULES += check
override COREMODULES += combine repository
override COREMODULES += install
override COREMODULES += ocenter

ifeq "$(ALLMODULES)" ""

override ALLMODULES += $(COREMODULES)

endif

# Work out which modules we can find to include.

_makeit_modules_options := \
 $(foreach module,$(filter $(MODULES),$(ALLMODULES)),\
  $(firstword $(wildcard $(addsuffix /$(module)-options.mk,$(MODULEPATH)))))

_makeit_modules_defns := \
 $(foreach module,$(filter $(MODULES),$(ALLMODULES)),\
  $(firstword $(wildcard $(addsuffix /$(module)-defns.mk,$(MODULEPATH)))))

_makeit_modules_init := \
 $(foreach module,$(filter $(MODULES),$(ALLMODULES)),\
  $(firstword $(wildcard $(addsuffix /$(module)-init.mk,$(MODULEPATH)))))

_makeit_modules_rules := \
 $(foreach module,$(filter $(MODULES),$(ALLMODULES)),\
  $(firstword $(wildcard $(addsuffix /$(module)-rules.mk,$(MODULEPATH)))))

# Include "options" part of any module files.

ifneq "$(_makeit_modules_options)" ""
include $(_makeit_modules_options)
endif

# Include definitions generated by configure script.

include $(OSE_HOST_MAKEIT)/config.mk

# Include definitions of what is to be built and what the
# default compiler is.

include $(OSE_HOST_MAKEIT)/build.mk

# Include definitions for initialisation of the compiler, variant
# and compiler environment variables.

include $(OSE_MAKEIT)/defaults.mk

# Include definitions giving compiler flags for each variant,
# host to build and install shared libraries etc etc.

include $(OSE_HOST_MAKEIT)/system.mk

# Include definitions as to where compilers and third party
# products are installed.

include $(OSE_HOST_MAKEIT)/site.mk

# Include internal definitions.

include $(OSE_MAKEIT)/compiler.mk

include $(OSE_MAKEIT)/general.mk

# Include "defns" part of any module files.
# "init" files are included for backwward
# compatbility only.

ifneq "$(_makeit_modules_defns)" ""
include $(_makeit_modules_defns)
endif

ifneq "$(_makeit_modules_init)" ""
include $(_makeit_modules_init)
endif
