## Copyright 1992 1993 OTC LIMITED
## Copyright 1995 DUMPLETON SOFTWARE CONSULTING PTY LIMITED

(%) : %

## Standard targets.

.PHONY : lib
.PHONY : lib.setup
# .PHONY : lib.subdirs
.PHONY : lib.target
.PHONY : lib.always

lib : lib.setup
# lib : lib.subdirs
lib : lib.target
lib : lib.always

lib.setup :: makeit.setup

# lib.subdirs :: lib.setup

lib.target :: lib.setup

lib.always :: lib.setup

.PHONY : shlib
.PHONY : shlib.setup
# .PHONY : shlib.subdirs
.PHONY : shlib.target
.PHONY : shlib.always

shlib : shlib.setup
# shlib : shlib.subdirs
shlib : shlib.target
shlib : shlib.always

shlib.setup :: makeit.setup

# shlib.subdirs :: shlib.setup

shlib.target :: shlib.setup

shlib.always :: shlib.setup

## Only bother with most of this file if we have a library to build.

_makeit_MK_LIB_OBJECTS := $(strip $(_makeit_MK_LIB_OBJECTS))

ifneq "$(_makeit_MK_LIB_OBJECTS)" ""

## Setup target so that library is built when the targets "all" or "lib"
## are used.

all.always :: lib

lib.always :: $(MK)/lib$(LIBEXT)

## Setup library archive targets.

PTRFLAGS.lib = -ptr$(MKPTR)

ifeq "$(filter ignore_repositories,$(MAKEIT_OPTIONS))" ""
ifneq "$(PTRDIRS)" ""
PTRFLAGS.lib += $(addprefix -ptr,$(PTRDIRS))
endif
endif

RUN-ARCHIVE.o = \
 $(AR) $(ARFLAGS) $@ $?; \
 $(RANLIB) $@

ifeq "$(_makeit_cxx_supports_cafe_repositories)" "YES"
ifeq "$(filter no_local_closure,$(MAKEIT_OPTIONS))" ""

RUN-ARCHIVE.o = \
 $(C++) -xar $(PTRFLAGS.lib) $(C++FLAGS) $(CPPFLAGS) -o $@ $?

endif
endif

ifneq "$(filter MS%,$(C++COMPILER))" ""

RUN-ARCHIVE.o = \
 (cd $(MK); $(dir $(C++))LIB -nologo -out:$(@F) $(^F) )

endif

ifneq "$(filter KAI%,$(C++COMPILER))" ""

RUN-ARCHIVE.o = \
 echo "main() {}" > $(MK)/lib.c; \
 $(C++) $(C++FLAGS) $(CPPFLAGS) $(MK)/lib.c -o $(MK)/lib.combine $^ \
  $(LDFLAGS) $(filter-out %.o,$(LDLIBS)); \
 $(RM) $(MK)/lib.c $(MK)/lib.combine; \
 $(AR) $(ARFLAGS) $@ $^; \
 $(RANLIB) $@

endif

$(MK)/lib$(LIBEXT) :: \
 $(_makeit_MK_LIB_OBJECTS)
	$(RUN-ARCHIVE.o)

ifeq "$(_makeit_enable_shared_libraries)" "YES"

all.always :: shlib

override STATIC := $(strip $(filter-out $(EXCLUDE),$(STATIC)))

ifneq "$(STATIC)" ""

shlib.always :: $(MK)/lib.sa$(LIBEXT)

$(MK)/lib.sa$(LIBEXT) :: \
 $(patsubst %,$(MK)/%$(OBJEXT),$(basename $(STATIC)))
	$(RUN-ARCHIVE.o)

endif

shlib.always :: $(MK)/lib.so$(LIBEXT)

RUN-ARCHIVE.so = \
 $(AR) $(ARFLAGS) $@ $^

RUN-LINK.so = \
 $(LD) -o $(MK)/lib.so $(LDPICFLAGS) $^

ifeq "$(_makeit_cxx_supports_cafe_repositories)" "YES"

RUN-LINK.so = \
 $(C++) -G $(patsubst -ptr%,-ptr%.pic,$(PTRFLAGS.lib)) \
 $(C++FLAGS) $(CPPFLAGS) -o $(MK)/lib.so $^ \
 $(LDFLAGS) $(filter-out %.o,$(LDLIBS))

endif

ifneq "$(filter KAI%,$(C++COMPILER))" ""

RUN-LINK.so = \
 $(C++) -G $(C++FLAGS) $(CPPFLAGS) -o $(MK)/lib.so $^ \
 $(LDFLAGS) $(filter-out %.o,$(LDLIBS))

endif

ifneq "$(filter HP3.%,$(C++COMPILER))" ""

RUN-LINK.so = \
 $(C++) -b $(PTRFLAGS.lib) $(C++FLAGS) $(CPPFLAGS) -o $(MK)/lib.so $^

endif

$(MK)/lib.so$(LIBEXT) :: \
 $(patsubst $(MK)/%$(OBJEXT),$(MK).pic/%$(OBJEXT),$(_makeit_MK_LIB_OBJECTS))
	$(RUN-LINK.so)
	$(RUN-ARCHIVE.so)

endif

endif

## ObjectStore schema database generation.

ifeq "$(C++COMPILERENV)" "OSTORE"

ifneq "$(SCHEMAS)" ""

# Adjust variables listing files if not in SRCDIR.

ifneq "$(SRCDIR)" "."
override SCHEMAS := $(foreach file,$(SCHEMAS),$(firstword $(wildcard \
 $(file) $(SRCDIR)/$(file)) $(file)))
endif

## Creation of schema database.

ifneq "$(filter 1% 2% 3%,$(OS_VERSION))" ""

OS_BATCH_SCHEMAS = $(OS_ROOTDIR)/bin/OSCC -DCXX_OS \
 $(OS_SCHEMAFLAGS) $(CPPFLAGS) -DSCHEMA_GENERATION \
 +OSTD -batch_schema "$(OS_COMPILATION_SCHEMA_DB_PATH)"

ifneq "$(filter-out 3.0 3.0.%,$(filter 3.%,$(OS_VERSION)))" ""
ifeq "$(_makeit_cxx_supports_cfront_repositories)" "YES"
OS_BATCH_SCHEMAS += -use_cfront_3.0_vtbl_names
endif
endif

lib.schema : $(MK)/osschema.standin

$(MK)/osschema.standin : $(SCHEMAS)
	$(OS_BATCH_SCHEMAS) $(SCHEMAS)
	touch $@

else

OS_LOAD_COMPILATION_SCHEMA = $(OS_ROOTDIR)/bin/ossg $(OS_SCHEMAFLAGS) \
 $(CPPFLAGS) $(filter -D% -I%,$(C++FLAGS)) -DSCHEMA_GENERATION \
 -csdb $(OS_COMPILATION_SCHEMA_DB_PATH)

lib.schema : $(OS_COMPILATION_SCHEMA_DB_PATH)

$(OS_COMPILATION_SCHEMA_DB_PATH) : $(SCHEMAS)
	@for i in $(SCHEMAS); \
	do \
	  echo $(OS_LOAD_COMPILATION_SCHEMA) $$i; \
	  $(OS_LOAD_COMPILATION_SCHEMA) $$i; \
	done

endif

endif

endif

ifneq "$(filter OS%,$(C++COMPILER))" ""

clean.always ::
ifneq "$(OS_COMPILATION_SCHEMA_DB_PATH)" ""
	osrm -f $(OS_COMPILATION_SCHEMA_DB_PATH)
endif
ifneq "$(OS_APPLICATION_SCHEMA_DB_PATH)" ""
	osrm -f $(OS_APPLICATION_SCHEMA_DB_PATH)
endif

else
ifeq "$(C++COMPILERENV)" "OSTORE"

ifneq "$(filter X86_NT%,$(OSE_HOST))" ""

clean.always ::
ifneq "$(OS_COMPILATION_SCHEMA_DB_PATH)" ""
	$(RM) $(OS_COMPILATION_SCHEMA_DB_PATH)
endif
ifneq "$(OS_APPLICATION_SCHEMA_DB_PATH)" ""
	$(RM) $(OS_APPLICATION_SCHEMA_DB_PATH)
endif

else

clean.always ::
ifneq "$(OS_COMPILATION_SCHEMA_DB_PATH)" ""
	osrm -f $(OS_COMPILATION_SCHEMA_DB_PATH)
endif
ifneq "$(OS_APPLICATION_SCHEMA_DB_PATH)" ""
	osrm -f $(OS_APPLICATION_SCHEMA_DB_PATH)
endif

endif

endif
endif
