## Copyright 1992 1993 OTC LIMITED
## Copyright 1995 DUMPLETON SOFTWARE CONSULTING PTY LIMITED

## Setup include file search path.

ifneq "$(filter otklib,$(OSE_OPTIONS))" ""
override REQUIRE += tcl
override TCL_OPTIONS += tk
# override CPPFLAGS += $(OTKLIB_CPPFLAGS)
endif

override CPPFLAGS += -I$(OSE_HOME)/include -I$(OSE_HOST_HOME)/include

## Setup location of parameterised types map file.

override PTMAPS += $(OSE_HOME)/include/OTC/PTMAP $(OSE_HOME)/include/OUX/PTMAP

ifneq "$(filter otklib,$(OSE_OPTIONS))" ""
override PTMAPS += $(OSE_HOME)/include/OTK/PTMAP
endif

## Setup library search path.

ifeq "$(filter use_static_libraries,$(OSE_OPTIONS))" ""
override LD_RUN_PATH := $(LD_RUN_PATH):$(OSE_HOST_HOME)/lib/$(C++COMPILERTAG)
override LDFLAGS += $(LOPT)$(OSE_HOST_HOME)/lib/$(C++COMPILERTAG)
endif

ifneq "$(filter otklib,$(OSE_OPTIONS))" ""
# override LDFLAGS += $(OTKLIB_LDFLAGS)
endif

## Setup ObjectStore library schema databse search path.

ifneq "$(filter OS%,$(C++COMPILER))" ""
override LDFLAGS += -OSL$(OSE_HOST_HOME)/lib/$(C++COMPILERTAG)
endif

ifneq "$(filter X86_NT%,$(OSE_HOST))" ""
override SCHEMAS += $(subst /,\,$(OSE_HOME)/include/OTC/SCHEMA.cc)
else
override SCHEMAS += $(OSE_HOME)/include/OTC/SCHEMA.cc
endif

## Work out which version of the library we are going to link with.
## Always force it to "prf" if that is the variant which the user is
## working in.

ifeq "$(VARIANT)" "prf"
OSE_VARIANT := prf
endif

ifeq "$(OSE_VARIANT)" ""
OSE_VARIANT := $(VARIANT)
endif

## Setup linking in of the libraries.

OSE_LIBRARY_RELTAG := $(subst .,X,$(OSE_RELEASE_NAME))
OSE_LIBRARY_PLTAG := $(patsubst pl00,,pl$(OSE_MAINTENANCE_RELEASE))
OSE_LIBRARY_CXXTAG := $(subst -,_,$(subst .,X,$(C++COMPILERTAG)))

OSE_LIBRARY_TAG := \
 $(OSE_LIBRARY_RELTAG)$(OSE_LIBRARY_PLTAG)_$(OSE_LIBRARY_CXXTAG)

ifeq "$(HAVE_LONG_FILE_NAMES)" "YES"
OSE_LIBSUFFIX := $(OSE_LIBRARY_TAG)_$(OSE_VARIANT)
else
OSE_LIBSUFFIX := $(OSE_VARIANT)
endif

ifneq "$(filter use_static_libraries,$(OSE_OPTIONS))" ""

ifneq "$(filter otklib,$(OSE_OPTIONS))" ""
override LDLIBS += \
 $(OSE_HOST_HOME)/lib/$(C++COMPILERTAG)/libOTK_$(OSE_LIBSUFFIX)$(LIBEXT)
endif

override LDLIBS += \
 $(OSE_HOST_HOME)/lib/$(C++COMPILERTAG)/libOUX_$(OSE_LIBSUFFIX)$(LIBEXT) \
 $(OSE_HOST_HOME)/lib/$(C++COMPILERTAG)/libOTC_$(OSE_LIBSUFFIX)$(LIBEXT) \
 $(OSE_HOST_HOME)/lib/$(C++COMPILERTAG)/libOSE$(LIBEXT)

else

ifeq "$(_makeit_cxx_broken_library_search)" "YES"

ifneq "$(filter otklib,$(OSE_OPTIONS))" ""
override LDLIBS += \
 $(OSE_HOST_HOME)/lib/$(C++COMPILERTAG)/libOTK_$(OSE_LIBSUFFIX)$(LIBEXT)
endif

override LDLIBS += \
 $(OSE_HOST_HOME)/lib/$(C++COMPILERTAG)/libOUX_$(OSE_LIBSUFFIX)$(LIBEXT) \
 $(OSE_HOST_HOME)/lib/$(C++COMPILERTAG)/libOTC_$(OSE_LIBSUFFIX)$(LIBEXT) \
 $(OSE_HOST_HOME)/lib/$(C++COMPILERTAG)/libOSE$(LIBEXT)

else

ifneq "$(filter otklib,$(OSE_OPTIONS))" ""
override LDLIBS += -lOTK_$(OSE_LIBSUFFIX)
endif

override LDLIBS += -lOUX_$(OSE_LIBSUFFIX) -lOTC_$(OSE_LIBSUFFIX) -lOSE

endif

endif

## Make sure we link in ObjectStore library if necessary.

# ifeq "$(C++COMPILERENV)" "OSTORE"
# ifeq "$(_makeit_cxx_broken_library_search)" "YES"
# override LDLIBS += $(OS_ROOTDIR)/lib/libos$(LIBEXT)
# else
# override LDLIBS += -los
# endif
# else
# ifneq "$(filter OS%,$(C++COMPILER))" ""
# override LDLIBS += -los
# endif
# endif

## Link in TK libraries.

ifneq "$(filter otklib,$(OSE_OPTIONS))" ""
# override LDLIBS += $(OTKLIB_LDLIBS)
endif
