## Copyright 1992 1993 OTC LIMITED
## Copyright 1995 DUMPLETON SOFTWARE CONSULTING PTY LIMITED

.PHONY : repository

## Only bother with this stuff if we have a compiler which can support it.

ifneq "$(_makeit_cxx_supports_cfront_repositories)" "YES"

repository :
	@echo makeit: repositories not supported with this compiler.

else

## Do this as part of main target.

all.always :: repository

## Work out strategy for expanding functions.

ifeq "$(filter minimal_expansion,$(REPOSITORY_OPTIONS))" ""
override C++FLAGS += -pta
endif

ifneq "$(filter separate_functions,$(REPOSITORY_OPTIONS))" ""
override C++FLAGS += -pts
endif

CLOSURE.cc = $(C++) $(C++FLAGS) -ptr$(MKPTR) $(CPPFLAGS) $(LDFLAGS)

## Adjust variables listing files if not in SRCDIR.

ifneq "$(SRCDIR)" "."

ifneq "$(PTDUMMYS)" ""
override PTDUMMYS := $(foreach file,$(PTDUMMYS),$(firstword $(wildcard \
 $(file) $(SRCDIR)/$(file)) $(file)))
endif

ifneq "$(PTMAPS)" ""
override PTMAPS := $(foreach file,$(PTMAPS),$(firstword $(wildcard \
 $(file) $(SRCDIR)/$(file)) $(file)))
endif

endif

ifeq "$(filter LC%,$(C++COMPILER))" ""
_repository_defmap := defmap
else
_repository_defmap := defaultmap
endif

## The actual hard work.

# Note: create dummy defmap files here as otherwise HP and Sun compiler
# will not kick in template instantiation.

repository : makeit.setup
	$(RM) *$(OBJEXT)
ifneq "$(filter %$(LIBEXT),$(LDLIBS))" ""
	@for i in $(filter %$(LIBEXT),$(LDLIBS)); \
	do \
	  echo $(RM) $(SYMDEFS); \
	  $(RM) $(SYMDEFS); \
	  echo "$(AR) xv $$i"; \
	  $(AR) xv $$i; \
	done
endif
	@if test ! -s $(MKPTR)/$(_repository_defmap); \
	then \
	  echo "@dec ____DUMMY____" > $(MKPTR)/$(_repository_defmap); \
	  echo "<____DUMMY____>" >> $(MKPTR)/$(_repository_defmap); \
	fi
ifneq "$(PTMAPS)" ""
	$(RM) $(MKPTR)/nmap*
	@NUM=1; \
	for i in $(PTMAPS); \
	do \
	  echo "cp $$i $(MKPTR)/nmap$$NUM"; \
	  cp $$i $(MKPTR)/nmap$$NUM; \
	  NUM=`expr $$NUM + 1`; \
	done
endif
	$(RM) $(MK)/__ptdummy*.c
ifneq "$(PTDUMMYS)" ""
	@NUM=1; \
	for i in $(PTDUMMYS); \
	do \
	  echo "cp $$i $(MK)/__ptdummy$$NUM.c"; \
	  cp $$i $(MK)/__ptdummy$$NUM.c; \
	  NUM=`expr $$NUM + 1`; \
	done
endif
	echo "main() { return 0; }" > $(MK)/__ptdummy0.c
ifneq "$(filter ignore_undefined_symbols,$(REPOSITORY_OPTIONS))" ""
	- $(CLOSURE.cc) $(MK)/__ptdummy*.c *$(OBJEXT) $(filter-out %$(LIBEXT),$(LDLIBS))
else
	$(CLOSURE.cc) $(MK)/__ptdummy*.c *$(OBJEXT) $(filter-out %$(LIBEXT),$(LDLIBS))
endif
	$(RM) $(MK)/__ptdummy*.c a.out $(SYMDEFS) *$(OBJEXT)

endif
