## Copyright 1992 1993 OTC LIMITED
## Copyright 1994 1995 DUMPLETON SOFTWARE CONSULTING PTY LIMITED

## Wipe out some default rules in GNU make so they do not give us problems.
## These are also in module files, but if module files are not included,
## they can give us problems if people use RCS/SCCS.

%.h :
%.hh :
%.hpp :
%.hxx :
%.H :
%.l :
%.r :
%.f :
%.x :

%$(OBJEXT) : %.c
% : %.c
%$(OBJEXT) : %.cc
% : %.cc
%$(OBJEXT) : %.cpp
% : %.cpp
%$(OBJEXT) : %.cxx
% : %.cxx
%$(OBJEXT) : %.C
% : %.C
%$(OBJEXT) : %.f
% : %.f
%$(OBJEXT) : %.l
% : %.l
%$(OBJEXT) : %.r
% : %.r

## Setup preprocessor, compiler and linker flags.

# Add in old variables for backwards compatability.

override PROJECT_CPPFLAGS += $(EXTRA_CPPFLAGS)
override PROJECT_C++FLAGS += $(EXTRA_C++FLAGS)
override PROJECT_CFLAGS += $(EXTRA_CFLAGS)
override PROJECT_LDFLAGS += $(EXTRA_LDFLAGS)
override PROJECT_LDLIBS += $(EXTRA_LDLIBS)

# Values specific to a project.

override CPPFLAGS += $(PROJECT_CPPFLAGS)
override C++FLAGS += $(PROJECT_C++FLAGS)
override CFLAGS += $(PROJECT_CFLAGS)
override LDFLAGS += $(PROJECT_LDFLAGS)
override LDLIBS += $(PROJECT_LDLIBS)

# Add LOADLIBES to the start of LDLIBS for backward compatability.

override LDLIBS := $(LOADLIBES) $(LDLIBS)
override LOADLIBES :=

# Which variants are supported for PIC and normal.

ifeq "$(origin $(C++COMPILER)_VARIANTS)" "file"
override VARIANTS := $($(C++COMPILER)_VARIANTS)
endif

override VARIANTS := $(strip $(VARIANTS))

ifeq "$(origin $(C++COMPILER)_PICVARIANTS)" "file"
override PICVARIANTS := $($(C++COMPILER)_PICVARIANTS)
endif

override PICVARIANTS := $(strip $(PICVARIANTS))

# Can we build shared libraries in this variant.

ifneq "$(filter $(VARIANT),$(PICVARIANTS))" ""
ifneq "$(filter shlib,$(MAKEIT_OPTIONS))" ""
_makeit_enable_shared_libraries := YES
else
_makeit_enable_shared_libraries := NO
endif
endif

# Shared library options from values defined in host file.

ifeq "$(origin $(C++COMPILER)_C++PICFLAGS)" "file"
override C++PICFLAGS := $($(C++COMPILER)_C++PICFLAGS)
endif

ifeq "$(origin $(C++COMPILER)_CPICFLAGS)" "file"
override CPICFLAGS := $($(C++COMPILER)_CPICFLAGS)
endif

ifeq "$(origin $(C++COMPILER)_LDPICFLAGS)" "file"
override LDPICFLAGS := $($(C++COMPILER)_LDPICFLAGS)
endif

override C++PICFLAGS += -DPIC
override CPICFLAGS += -DPIC

# Library search path option.

ifeq "$(origin $(C++COMPILER)_LOPT)" "file"
override LOPT := $($(C++COMPILER)_LOPT)
endif

# Make sure LD_RUN_PATH is exported for Solaris platform.

export LD_RUN_PATH

# List of names of SYMDEF files created by ranlib in libraries.

override SYMDEFS := __.SYMDEF _*EB_ _*EL_

## Set up Sentinel products.

ifeq "$(SENTINEL)" ""
ifneq "$(SE_HOME)" ""
export SE_HOME
SENTINEL := $(SE_HOME)/sentinel $(SENTINELOPTIONS)
else
SENTINEL := sentinel $(SENTINELOPTIONS)
endif
endif

# Check for enabling of Sentinel.

ifeq "$(_makeit_enable_memcheck)" ""
ifneq "$(filter sentinel,$(MAKEIT_OPTIONS))" ""
_makeit_cleanup_sentinel := YES
_makeit_enable_memcheck := YES
override MEMCHECK := $(SENTINEL)
override MEMEXT := sent
endif
endif

ifeq "$(_makeit_enable_memcheck_all)" ""
ifneq "$(filter sentinel_all,$(MAKEIT_OPTIONS))" ""
_makeit_cleanup_sentinel := YES
_makeit_enable_memcheck_all := YES
override MEMCHECKALL := $(SENTINEL)
endif
endif

## Set up TestCenter products.

ifeq "$(PROOF)" ""
ifneq "$(CENTERLINE_HOME)" ""
export CENTERLINE_HOME
PROOF := $(CENTERLINE_HOME)/bin/proof $(PROOFOPTIONS)
else
PROOF := proof $(PROOFOPTIONS)
endif
endif

# Check for enabling of TestCenter.

ifeq "$(_makeit_enable_memcheck)" ""
ifneq "$(filter testcenter,$(MAKEIT_OPTIONS))" ""
_makeit_cleanup_testcenter := YES
_makeit_enable_memcheck := YES
override MEMCHECK := $(PROOF)
override MEMEXT := tc
endif
endif

ifeq "$(_makeit_enable_memcheck_all)" ""
ifneq "$(filter testcenter_all,$(MAKEIT_OPTIONS))" ""
_makeit_cleanup_testcenter := YES
_makeit_enable_memcheck_all := YES
override MEMCHECKALL := $(PROOF)
endif
endif

## Set up Pure Software products.

ifeq "$(PURIFY)" ""
ifneq "$(PURIFYHOME)" ""
export PURIFYHOME
PURIFY := $(PURIFYHOME)/purify
else
PURIFY := purify
endif
endif

ifeq "$(PURECOV)" ""
ifneq "$(PURECOVHOME)" ""
export PURECOVHOME
PURECOV := $(PURECOVHOME)/purecov
else
PURECOV := purecov
endif
endif

ifeq "$(PURELINK)" ""
ifneq "$(PURELINKHOME)" ""
export PURELINKHOME
PURELINK := $(PURELINKHOME)/purelink
else
PURELINK := purelink
endif
endif

ifeq "$(QUANTIFY)" ""
ifneq "$(QUANTIFYHOME)" ""
export QUANTIFYHOME
QUANTIFY := $(QUANTIFYHOME)/quantify
else
QUANTIFY := quantify
endif
endif

# Check for environment variables which customise the behaviour of
# Purify/Quantify. If any are set then make sure they are exported as they
# may only be defined in the make files and not in the users environment.

ifdef PURIFYTMPDIR
export PURIFYTMPDIR
endif

ifdef PURIFYCACHEDIR
export PURIFYCACHEDIR
endif

ifdef PURIFYALWAYSUSECACHEDIR
export PURIFYALWAYSUSECACHEDIR
endif

ifdef PURIFYOPTIONS
export PURIFYOPTIONS
endif

ifdef PURECOVOPTIONS
export PURECOVOPTIONS
endif

ifdef PURELINKOPTIONS
export PURELINKOPTIONS
endif

ifdef QUANTIFYOPTIONS
export QUANTIFYOPTIONS
endif

# Check for enabling of Purify/PureLink/Quantify. In the case of conflicts,
# Purify takes precedence.

ifeq "$(_makeit_enable_memcheck)" ""
ifneq "$(filter purecov,$(MAKEIT_OPTIONS))" ""
_makeit_cleanup_pure := YES
_makeit_enable_memcheck := YES
override MEMCHECK := $(PURECOV)
override MEMEXT := pure
endif
endif

ifeq "$(_makeit_enable_memcheck_all)" ""
ifneq "$(filter purecov_all,$(MAKEIT_OPTIONS))" ""
_makeit_cleanup_pure := YES
_makeit_enable_memcheck_all := YES
override MEMCHECKALL := $(PURECOV)
endif
endif

ifeq "$(_makeit_enable_memcheck)" ""
ifneq "$(filter quantify,$(MAKEIT_OPTIONS))" ""
_makeit_cleanup_pure := YES
_makeit_enable_memcheck := YES
override MEMCHECK := $(QUANTIFY)
override MEMEXT := pure
endif
endif

ifeq "$(_makeit_enable_memcheck_all)" ""
ifneq "$(filter quantify_all,$(MAKEIT_OPTIONS))" ""
_makeit_cleanup_pure := YES
_makeit_enable_memcheck_all := YES
override MEMCHECKALL := $(QUANTIFY)
endif
endif

ifeq "$(_makeit_enable_memcheck_all)" ""
ifneq "$(filter purelink_all,$(MAKEIT_OPTIONS))" ""
_makeit_cleanup_pure := YES
_makeit_enable_memcheck_all := YES
override MEMCHECKALL := $(PURELINK)
endif
endif

ifeq "$(_makeit_enable_memcheck)" ""
ifneq "$(filter purify,$(MAKEIT_OPTIONS))" ""
_makeit_cleanup_pure := YES
_makeit_enable_memcheck := YES
override MEMCHECK :=
override MEMEXT := pure
ifneq "$(filter purelink,$(MAKEIT_OPTIONS))" ""
override MEMCHECK += $(PURELINK)
endif
override MEMCHECK += $(PURIFY)
ifneq "$(filter purecov,$(MAKEIT_OPTIONS))" ""
override MEMCHECK += $(PURECOV)
endif
endif
endif

ifeq "$(_makeit_enable_memcheck_all)" ""
ifneq "$(filter purify_all,$(MAKEIT_OPTIONS))" ""
_makeit_cleanup_pure := YES
_makeit_enable_memcheck_all := YES
override MEMCHECKALL :=
ifneq "$(filter purelink_all,$(MAKEIT_OPTIONS))" ""
override MEMCHECKALL += $(PURELINK)
endif
override MEMCHECKALL += $(PURIFY)
ifneq "$(filter purecov_all,$(MAKEIT_OPTIONS))" ""
override MEMCHECKALL += $(PURECOV)
endif
endif
endif

## Set up location of scripts.

ifeq "$(origin SCRIPTDIR)" "undefined"
SCRIPTDIR = $(OSE_HOME)/etc
endif

## Some stuff for ObjectStore.

ifneq "$(filter OS%,$(C++COMPILER))" ""
ifeq "$(C++COMPILERENV)" ""
ifneq "$(filter +OSTD,$(INTERNAL_C++FLAGS))" ""
override C++ := exit 1; *** +OSTD cannot be used with $(C++COMPILER),\
 set C++COMPILER to OSTORE-$(C++COMPILER) to achieve the same affect ***
endif
endif
endif

ifeq "$(origin OS_APPLICATION_SCHEMA_DB_PATH)" "undefined"
ifneq "$(filter 1% 2% 3%,$(OS_VERSION))" ""
OS_APPLICATION_SCHEMA_DB_PATH := $(MK)/appl.schema
else
OS_APPLICATION_SCHEMA_DB_PATH := $(MK)/osschema.adb
endif
endif

ifeq "$(origin OS_COMPILATION_SCHEMA_DB_PATH)" "undefined"
ifneq "$(filter 1% 2% 3%,$(OS_VERSION))" ""
OS_COMPILATION_SCHEMA_DB_PATH := $(MK)/comp.schema
else
OS_COMPILATION_SCHEMA_DB_PATH := $(MK)/osschema.cdb
endif
endif

ifeq "$(C++COMPILERENV)" "OSTORE"
ifeq "$(filter 1% 2% 3%,$(OS_VERSION))" ""
ifneq "$(SCHEMAS)" ""
ifeq "$(filter MS%,$(C++COMPILER))" ""
_cc_generated_NONLIB_SRC += osschema.cc
REQUIRE += cc
endif
endif
endif
endif

## Some stuff for Versant.

ifeq "$(C++COMPILERENV)" "VERSANT"
IMPFILES := $(filter-out $(EXCLUDE),$(filter %.imp,$(SRCFILES)))
override EXCLUDE += $(patsubst %.imp,%.cxx,$(IMPFILES))
_cxx_generated_NONLIB_SRC += $(patsubst %.imp,%.cxx,$(IMPFILES))
ifneq "$(IMPFILES)" ""
REQUIRE += cxx
endif
endif

## Make subdirectories into which compiled components will be placed.

ifneq "$(NOMK)" "YES"

makeit.setup :: $(MK)

$(MK) :
	@mkdir $@

ifeq "$(_makeit_enable_shared_libraries)" "YES"

makeit.setup :: $(MK).pic

$(MK).pic :
	@mkdir $@

endif

ifneq "$(filter always_create_subdirectory,$(MAKEIT_OPTIONS))" ""
override _makeit_dummy := $(shell test -d $(MK) || mkdir $(MK))
endif

ifeq "$(_makeit_cxx_supports_xl_repositories)" "YES"

_makeit_cxx_requires_repository := YES

makeit.setup :: $(MKPTR)

$(MKPTR) :
	@mkdir $@

endif

ifeq "$(_makeit_cxx_supports_cfront_repositories)" "YES"

_makeit_cxx_requires_repository := YES

makeit.setup :: $(MKPTR)

$(MKPTR) :
	@mkdir $@

endif

ifeq "$(_makeit_cxx_supports_cafe_repositories)" "YES"

_makeit_cxx_requires_repository := YES

makeit.setup :: $(MKPTR)

$(MKPTR) :
	@mkdir $@
	@mkdir $@/Templates.DB
	@mkdir $@/Templates.DB/Module.DB

ifeq "$(_makeit_enable_shared_libraries)" "YES"

makeit.setup :: $(MKPTR).pic

$(MKPTR).pic :
	@mkdir $@
	@mkdir $@/Templates.DB
	@mkdir $@/Templates.DB/Module.DB

endif

endif

endif
