/*
// ============================================================================
//
// = LIBRARY
//     OTC
// 
// = FILENAME
//     collctn/_prvisitr.cc
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1993 TELSTRA CORPORATION LIMITED
//
// ============================================================================
*/

#include <OTC/debug/tracer.hh>
#include <OTC/collctn/map.hh>

#include <stdlib.h>

/* ------------------------------------------------------------------------- */

#ifdef __OSE_TEMPLATES__
template<class T1, class T2> EXVS_Sum
{
  OSE_TEMPLATE OTC_PairVisitor<T1,T2>;
};
#endif

template<class T1, class T2>
class EXVS_Sum : public OTC_PairVisitor<T1,T2>
{
  public:

			EXVS_Sum() : mySum(0) {}

    void		start();

    void		finish();

    OTC_Progress	action(T1 const& theKey, T2 const& theItem);

    T2			sum() const
				{ return mySum; }

			operator T2() const
				{ return mySum; }

  private:

    T2			mySum;
};

template<class T1, class T2>
void EXVS_Sum<T1,T2>::start()
{
  // Nothing to do.
}

template<class T1, class T2>
void EXVS_Sum<T1,T2>::finish()
{
  // Nothing to do.
}

template<class T1, class T2>
OTC_Progress EXVS_Sum<T1,T2>::action(T1 const&, T2 const& theItem)
{
  mySum += theItem;
  return OTCLIB_CONTINUE;
}

#ifdef __OSE_TEMPLATES__
OSE_TEMPLATE OTC_Map<int,int>;
OSE_TEMPLATE EXVS_Sum<int,int>;
#endif

void test2()
{
  OTC_Tracer tracer("void test2()");

  OTC_Map<int,int> map;
  for (int i=0; i<100; i++)
    map.add(i,i);

  EXVS_Sum<int,int> sum;
  map.pairs().apply(sum);

  cout << "sum = " << sum << endl;

  OTC_PairIterator<int,int> iter = 0;
  iter = map.pairs();
  iter.apply(sum);

  cout << "sum = " << sum << endl;
}

void test1()
{
  OTC_Tracer tracer("void test1()");

  test2();
}

typedef void (*testFunc)();

testFunc tests[] =
{
  test1,
  test2
};

/* ------------------------------------------------------------------------- */

main(int argc, char* argv[])
{
  u_int const numTests = sizeof(tests)/sizeof(tests[0]);

  set_terminate(otclib_terminate_handler);

  if (argc != 2)
  {
    cout << numTests << endl;
    return 1;
  }
  else
  {
    int testNum = atoi(argv[1]);
    if (testNum > 0 && u_int(testNum) <= numTests)
    {
      tests[testNum-1]();
      return 0;
    }
    else
      return 1;
  }
}

/* ------------------------------------------------------------------------- */
