/*
// ============================================================================
//
// = LIBRARY
//     OTC
// 
// = FILENAME
//     collctn/_vector.cc
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1992 OTC LIMITED
//     Copyright 1995 DUMPLETON SOFTWARE CONSULTING PTY LIMITED
//
// ============================================================================
*/

#include <OTC/collctn/vector.hh>
#include <OTC/debug/logger.hh>
#include <OTC/debug/tracer.hh>

#include <stdlib.h>

/* ------------------------------------------------------------------------- */

#ifdef __OSE_TEMPLATES__
OSE_TEMPLATE OTC_Vector<int>
#endif

// = TEST 2
//     Test of fixed size vector

void test2()
{
  OTC_Tracer tracer("void test2()");

  OTC_Vector<int> vec(10);

  tracer() << "vec.size() = " << vec.size() << endl;

  u_int i;
  for (i=0; i<vec.size(); i++)
    vec[i] = i*i;

  tracer() << "vec =" << flush;
  for (i=0; i<vec.size(); i++)
    tracer() << " " << vec[i] << flush;
  tracer() << endl;
}

// = TEST 3
//     Test copy constructor.

void test3()
{
  OTC_Tracer tracer("void test3()");

  OTC_Vector<int> vec1(10);

  u_int i;
  for (i=0; i<vec1.size(); i++)
    vec1[i] = i*i;

  OTC_Vector<int> vec2(vec1);

  tracer() << "vec1 =" << flush;
  for (i=0; i<vec1.size(); i++)
    tracer() << " " << vec1[i] << flush;
  tracer() << endl;

  tracer() << "vec2 =" << flush;
  for (i=0; i<vec2.size(); i++)
    tracer() << " " << vec2[i] << flush;
  tracer() << endl;
}

// = TEST 4
//     Test copy constructor of range.

void test4()
{
  OTC_Tracer tracer("void test4()");

  OTC_Vector<int> vec1(10);

  u_int i;
  for (i=0; i<vec1.size(); i++)
    vec1[i] = i*i;

  OTC_Range rng(1,8);
  OTC_Vector<int> vec2(vec1,rng);

  tracer() << "vec1 =" << flush;
  for (i=0; i<vec1.size(); i++)
    tracer() << " " << vec1[i] << flush;
  tracer() << endl;

  tracer() << "vec2 =" << flush;
  for (i=0; i<vec2.size(); i++)
    tracer() << " " << vec2[i] << flush;
  tracer() << endl;

  OTC_Vector<int> vec3(vec1,rng.lower(),rng.length());

  tracer() << "vec1 =" << flush;
  for (i=0; i<vec1.size(); i++)
    tracer() << " " << vec1[i] << flush;
  tracer() << endl;

  tracer() << "vec3 =" << flush;
  for (i=0; i<vec3.size(); i++)
    tracer() << " " << vec3[i] << flush;
  tracer() << endl;
}

// = TEST 5
//     Test copying of array.

int test5vec1[] = { 0, 1, 4, 9, 16, 25, 36, 49, 64, 81 };

void test5()
{
  OTC_Tracer tracer("void test5()");

  OTC_Vector<int> vec2(test5vec1,10);

  tracer() << "vec1 =" << flush;
  u_int i;
  for (i=0; i<10; i++)
    tracer() << " " << test5vec1[i] << flush;
  tracer() << endl;

  tracer() << "vec2 =" << flush;
  for (i=0; i<vec2.size(); i++)
    tracer() << " " << vec2[i] << flush;
  tracer() << endl;
}

// = TEST 6
//     Test of resizing.

void test6()
{
  OTC_Tracer tracer("void test6()");

  OTC_Vector<int> vec(10);

  tracer() << "vec.size() = " << vec.size() << endl;

  u_int i;
  for (i=0; i<vec.size(); i++)
    vec[i] = i*i;

  tracer() << "vec =" << flush;
  for (i=0; i<vec.size(); i++)
    tracer() << " " << vec[i] << flush;
  tracer() << endl;

  tracer() << "vec.resize(5)" << endl;

  vec.resize(5);

  tracer() << "vec.size() = " << vec.size() << endl;

  tracer() << "vec =" << flush;
  for (i=0; i<vec.size(); i++)
    tracer() << " " << vec[i] << flush;
  tracer() << endl;

  tracer() << "vec.resize(10)" << endl;

  vec.resize(10);

  for (i=5; i<vec.size(); i++)
    vec[i] = i*i;

  tracer() << "vec.size() = " << vec.size() << endl;

  tracer() << "vec =" << flush;
  for (i=0; i<vec.size(); i++)
    tracer() << " " << vec[i] << flush;
  tracer() << endl;
}

// = TEST 1
//     All tests.

void test1()
{
  OTC_Tracer tracer("void test1()");

  test2();
  test3();
  test4();
  test5();
  test6();
}

/* ------------------------------------------------------------------------- */

typedef void (*testFunc)();

testFunc tests[] =
{
  test1,
  test2,
  test3,
  test4,
  test5
};

/* ------------------------------------------------------------------------- */

main(int argc, char* argv[])
{
  u_int const numTests = sizeof(tests)/sizeof(tests[0]);

  set_terminate(otclib_terminate_function);

  if (argc != 2)
  {
    cout << numTests << endl;
    return 1;
  }
  else
  {
    int testNum = atoi(argv[1]);
    if (testNum > 0 && u_int(testNum) <= numTests)
    {
      tests[testNum-1]();
      return 0;
    }
    else
      return 1;
  }
}

/* ------------------------------------------------------------------------- */
