/*
// ============================================================================
//
// = LIBRARY
//     OTC
// 
// = FILENAME
//     collctn/_visitor.cc
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1993 TELSTRA CORPORATION LIMITED
//
// ============================================================================
*/

#include <OTC/debug/tracer.hh>
#include <OTC/collctn/deque.hh>

#include <stdlib.h>

/* ------------------------------------------------------------------------- */

#ifdef __OSE_TEMPLATES__
template<class T> EXVS_Sum
{
  OSE_TEMPLATE OTC_Visitor<T>;
};
#endif

template<class T>
class EXVS_Sum : public OTC_Visitor<T>
{
  public:

			EXVS_Sum() : mySum(0) {}

    void		start();

    void		finish();

    OTC_Progress	action(T const& theItem);

    T			sum() const
				{ return mySum; }

			operator T() const
				{ return mySum; }

  private:

    T			mySum;
};

template<class T>
void EXVS_Sum<T>::start()
{
  // Nothing to do.
}

template<class T>
void EXVS_Sum<T>::finish()
{
  // Nothing to do.
}

template<class T>
OTC_Progress EXVS_Sum<T>::action(T const& theItem)
{
  mySum += theItem;
  return OTCLIB_CONTINUE;
}

#ifdef __OSE_TEMPLATES__
OSE_TEMPLATE OTC_Deque<int>;
OSE_TEMPLATE EXVS_Sum<int>;
#endif

void test2()
{
  OTC_Tracer tracer("void test2()");

  OTC_Deque<int> list;
  for (int i=0; i<100; i++)
    list.addLast(i);

  EXVS_Sum<int> sum;
  list.items().apply(sum);

  tracer() << "sum = " << sum << endl;

  OTC_Iterator<int> iter = 0;
  iter = list.items();
  iter.apply(sum);

  tracer() << "sum = " << sum << endl;
}

void test1()
{
  OTC_Tracer tracer("void test1()");

  test2();
}

typedef void (*testFunc)();

testFunc tests[] =
{
  test1,
  test2
};

/* ------------------------------------------------------------------------- */

main(int argc, char* argv[])
{
  u_int const numTests = sizeof(tests)/sizeof(tests[0]);

  set_terminate(otclib_terminate_handler);

  if (argc != 2)
  {
    cout << numTests << endl;
    return 1;
  }
  else
  {
    int testNum = atoi(argv[1]);
    if (testNum > 0 && u_int(testNum) <= numTests)
    {
      tests[testNum-1]();
      return 0;
    }
    else
      return 1;
  }
}

/* ------------------------------------------------------------------------- */
