/*
// ============================================================================
//
// = LIBRARY
//     OTC
// 
// = FILENAME
//     collctn/_worker.cc
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1993 TELSTRA CORPORATION LIMITED
//
// ============================================================================
*/

#include <OTC/debug/tracer.hh>
#include <OTC/collctn/deque.hh>

#include <stdlib.h>

/* ------------------------------------------------------------------------- */

#ifdef __OSE_TEMPLATES__
template<class T> EXWK_Square
{
  OSE_TEMPLATE OTC_Worker<T>;
};
#endif

template<class T>
class EXWK_Square : public OTC_Worker<T>
{
  public:

			EXWK_Square() {}

    void		start();

    void		finish();

    OTC_Progress	action(T& theItem);
};

template<class T>
void EXWK_Square<T>::start()
{
  // Nothing to do.
}

template<class T>
void EXWK_Square<T>::finish()
{
  // Nothing to do.
}

template<class T>
OTC_Progress EXWK_Square<T>::action(T& theItem)
{
  theItem = theItem * theItem;
  return OTCLIB_CONTINUE;
}

#ifdef __OSE_TEMPLATES__
OSE_TEMPLATE OTC_Deque<int>;
OSE_TEMPLATE EXWK_Square<int>;
#endif

void test2()
{
  OTC_Tracer tracer("void test2()");

  OTC_Deque<int> list;
  for (int i=0; i<100; i++)
    list.addLast(i);

  EXWK_Square<int> square;
  list.items().apply(square);

  OTC_Iterator<int> items = 0;
  items = list.items();
  for (items.reset(); items.isValid(); items.next())
    cout << items.item() << " ";
  cout << endl;
}

void test1()
{
  OTC_Tracer tracer("void test1()");

  test2();
}

typedef void (*testFunc)();

testFunc tests[] =
{
  test1,
  test2
};

/* ------------------------------------------------------------------------- */

main(int argc, char* argv[])
{
  u_int const numTests = sizeof(tests)/sizeof(tests[0]);

  set_terminate(otclib_terminate_handler);

  if (argc != 2)
  {
    cout << numTests << endl;
    return 1;
  }
  else
  {
    int testNum = atoi(argv[1]);
    if (testNum > 0 && u_int(testNum) <= numTests)
    {
      tests[testNum-1]();
      return 0;
    }
    else
      return 1;
  }
}

/* ------------------------------------------------------------------------- */
