/*
// ============================================================================
//
// = LIBRARY
//     OTC
// 
// = FILENAME
//     collctn/otcavltree.cc
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1992 OTC LIMITED
//     Copyright 1995 DUMPLETON SOFTWARE CONSULTING PTY LIMITED
//
// ============================================================================
*/

#ifdef __GNUG__
#pragma implementation "OTC/collctn/avltree.hh"
#endif

#include <OTC/collctn/avltree.hh>

#if defined(ENV_OSTORE)
/* ------------------------------------------------------------------------- */
os_typespec* OTC_AVLTree::typespec()
{
  static os_typespec ts("OTC_AVLTree");
  return &ts;
}
#endif

/* ------------------------------------------------------------------------- */
OTC_AVLTree::~OTC_AVLTree()
{
  removeAll();
}

/* ------------------------------------------------------------------------- */
OTC_AVLTree::OTC_AVLTree()
  : myRoot(0), myPopulation(0)
{
  // Nothing to do.
}

/* ------------------------------------------------------------------------- */
void OTC_AVLTree::removeAll()
{
  if (myRoot != 0)
    delete myRoot;
  myRoot = 0;
}

/* ------------------------------------------------------------------------- */
void OTC_AVLTree::addRoot(OTC_AVLNode* theNode)
{
  OTCLIB_ENSURE((root() == 0),
   "OTC_AVLTree::addRoot() - This tree already has a root node");
  OTCLIB_ENSURE((theNode != 0),
   "OTC_AVLTree::addRoot() - Must have valid object to use as root node");
  OTCLIB_ENSURE((theNode->tree() == 0),
   "OTC_AVLTree::addRoot() - Root node is already in a tree");

  myRoot = theNode;
  theNode->_setTree(this);
  myPopulation = 1;
}

/* ------------------------------------------------------------------------- */
int OTC_AVLTree::depth() const
{
  if (isEmpty())
    return -1;

  return root()->height() - 1;
}

/* ------------------------------------------------------------------------- */
OTC_AVLNode* OTC_AVLTree::_node(u_int theIndex) const
{
  if (theIndex >= population())
    return 0;

  theIndex++;
  OTC_AVLNode const* theNode = root();
  u_int fullCount = 0;
  u_int tmpCount = theNode->count();
  while ((fullCount+tmpCount) != theIndex)
  {
    if (theIndex > (fullCount+tmpCount))
    {
      theNode = theNode->right();
      fullCount += tmpCount;
      tmpCount = theNode->count();
    }
    else
    {
      theNode = theNode->left();
      tmpCount = theNode->count();
    }
  }
  return (OTC_AVLNode*)theNode;
}

/* ------------------------------------------------------------------------- */
OTC_AVLNode* OTC_AVLTree::_first() const
{
  if (root() != 0)
    return root()->_first();

  return 0;
}

/* ------------------------------------------------------------------------- */
OTC_AVLNode* OTC_AVLTree::_last() const
{
  if (root() != 0)
    return root()->_last();

  return 0;
}

/* ------------------------------------------------------------------------- */
