/*
// ============================================================================
//
// = LIBRARY
//     OTC
// 
// = FILENAME
//     collctn/otcbitsetc.cc
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1992 1994 OTC LIMITED
//     Copyright 1994 DUMPLETON SOFTWARE CONSULTING PTY LIMITED
//
// ============================================================================
*/

#ifdef __GNUG__
#pragma implementation "OTC/collctn/bitsetc.hh"
#endif

#include <OTC/collctn/bitsetc.hh>

#if defined(ENV_OSTORE)
/* ------------------------------------------------------------------------- */
os_typespec* OTC_BitSetC::typespec()
{
  static os_typespec ts("OTC_BitSetC");
  return &ts;
}
#endif

/* ------------------------------------------------------------------------- */
u_char OTC_BitSetC::globCounts[256] =
{
  0, 1, 1, 2, 1, 2, 2, 3, 1, 2, 2, 3, 2, 3, 3, 4,
  1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5,
  1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5,
  2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6,
  1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5,
  2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6,
  2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7,
  1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5,
  2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6,
  2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7,
  2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8
};

/* ------------------------------------------------------------------------- */
OTC_BitSetC::OTC_BitSetC(char const* theString)
{
  memset(mySet,0,32);

  if (theString != 0)
  {
    while (*theString != EOS)
      set(*theString++);
  }
}

/* ------------------------------------------------------------------------- */
OTC_BitSetC::OTC_BitSetC(char const* theString, u_int theNum)
{
  OTCLIB_ENSURE((theString != 0 || theNum == 0),
   "OTC_BitSetC(char const*, u_int) - Null pointer but non zero count");

  memset(mySet,0,32);

  if (theString != 0 && theNum != 0)
  {
    while (theNum-- != 0)
      set(*theString++);
  }
}

/* ------------------------------------------------------------------------- */
int OTC_BitSetC::count() const
{
  int theCount = 0;
  for (int i=0; i<32; i++)
    theCount += globCounts[mySet[i]];

  return theCount;
}

/* ------------------------------------------------------------------------- */
void OTC_BitSetC::reset(u_char theStart, u_char theNum)
{
  OTCLIB_ENSURE((u_int(theStart+theNum) <= 256),
   "OTC_BitSetC::reset(u_char, u_char) - Invalid range");

  while (theNum != 0)
  {
    reset(theStart+theNum-1);
    theNum--;
  }
}

/* ------------------------------------------------------------------------- */
void OTC_BitSetC::set(u_char theStart, u_char theNum)
{
  OTCLIB_ENSURE((u_int(theStart+theNum) <= 256),
   "OTC_BitSetC::set(u_char, u_char) - Invalid range");

  while (theNum != 0)
  {
    set(theStart+theNum-1);
    theNum--;
  }
}

/* ------------------------------------------------------------------------- */
void OTC_BitSetC::complement()
{
  for (u_int i=0; i<32; i++)
    mySet[i] = ~mySet[i];
}

/* ------------------------------------------------------------------------- */
void OTC_BitSetC::complement(u_char theStart, u_char theNum)
{
  OTCLIB_ENSURE((u_int(theStart+theNum) <= 256),
   "OTC_BitSetC::complement(u_char, u_char) - Invalid range");

  while (theNum != 0)
  {
    complement(theStart+theNum-1);
    theNum--;
  }
}

/* ------------------------------------------------------------------------- */
OTC_BitSetC OTC_BitSetC::operator~() const
{
  OTC_BitSetC bitset(*this);
  bitset.complement();
  return bitset;
}

/* ------------------------------------------------------------------------- */
OTC_BitSetC OTC_BitSetC::operator&(OTC_BitSetC const& theSet)
{
  OTC_BitSetC bitset;
  for (u_int i=0; i<32; i++)
    bitset.mySet[i] = mySet[i] & theSet.mySet[i];
  return bitset;
}

/* ------------------------------------------------------------------------- */
OTC_BitSetC& OTC_BitSetC::operator&=(OTC_BitSetC const& theSet)
{
  for (u_int i=0; i<32; i++)
    mySet[i] &= theSet.mySet[i];
  return *this;
}

/* ------------------------------------------------------------------------- */
OTC_BitSetC OTC_BitSetC::operator|(OTC_BitSetC const& theSet)
{
  OTC_BitSetC bitset;
  for (u_int i=0; i<32; i++)
    bitset.mySet[i] = mySet[i] | theSet.mySet[i];
  return bitset;
}

/* ------------------------------------------------------------------------- */
OTC_BitSetC& OTC_BitSetC::operator|=(OTC_BitSetC const& theSet)
{
  for (u_int i=0; i<32; i++)
    mySet[i] |= theSet.mySet[i];
  return *this;
}

/* ------------------------------------------------------------------------- */
OTC_BitSetC OTC_BitSetC::operator^(OTC_BitSetC const& theSet)
{
  OTC_BitSetC bitset;
  for (u_int i=0; i<32; i++)
    bitset.mySet[i] = mySet[i] ^ theSet.mySet[i];
  return bitset;
}

/* ------------------------------------------------------------------------- */
OTC_BitSetC& OTC_BitSetC::operator^=(OTC_BitSetC const& theSet)
{
  for (u_int i=0; i<32; i++)
    mySet[i] ^= theSet.mySet[i];
  return *this;
}

#if defined(CXX_OS)
/* ------------------------------------------------------------------------- */
int OTC_RankActions<OTC_BitSetC>::rank(
 OTC_BitSetC const& theSet1,
 OTC_BitSetC const& theSet2
)
{
  return OTC_BitSetC::rank(theSet1,theSet2);
}

/* ------------------------------------------------------------------------- */
int OTC_HashActions<OTC_BitSetC>::hash(OTC_BitSetC const& theSet)
{
  return OTC_BitSetC::hash(theSet);
}
#endif

/* ------------------------------------------------------------------------- */
