/*
// ============================================================================
//
// = LIBRARY
//     OTC
// 
// = FILENAME
//     collctn/otcdequei.cc
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1994 1995 DUMPLETON SOFTWARE CONSULTING PTY LIMITED
//
// ============================================================================
*/

#ifdef __GNUG__
#pragma implementation "OTC/collctn/dequei.hh"
#endif

#include <OTC/collctn/dequei.hh>

/* ------------------------------------------------------------------------- */
OTC_DequeI::~OTC_DequeI()
{
  myCount->unReference();
  myList->unReference();
}

/* ------------------------------------------------------------------------- */
OTC_DequeI::OTC_DequeI()
{
#if defined(ENV_OSTORE_DML) || defined(ENV_OSTORE)
  OTC_Locality theLocality = OTC_Locality::of(this);
#endif

#if defined(ENV_OSTORE_DML)
  myList = new ((os_segment*)theLocality) OTC_LinkList;
#else
#if defined(ENV_OSTORE)
  myList = new (theLocality,OTC_LinkList::get_os_typespec()) OTC_LinkList;
#else
  myList = new OTC_LinkList;
#endif
#endif
  OTCLIB_ASSERT(myList != 0);
  myList->reference();

#if defined(ENV_OSTORE_DML)
    myCount = new ((os_segment*)theLocality) OTC_RCount;
#else
#if defined(ENV_OSTORE)
  myCount = new (theLocality,OTC_RCount::get_os_typespec()) OTC_RCount;
#else
  myCount = new OTC_RCount;
#endif
#endif
  OTCLIB_ASSERT(myCount != 0);
  myCount->reference();
}

/* ------------------------------------------------------------------------- */
OTC_DequeI::OTC_DequeI(OTC_DequeI const& theList)
{
  myList = theList.myList;
  myList->reference();

  myCount = theList.myCount;
  myCount->reference();
}

/* ------------------------------------------------------------------------- */
void OTC_DequeI::remove(OTC_Link* theLink)
{
  OTCLIB_ENSURE((myCount->count() != 0),
   "OTC_DequeI::remove() - List is empty");
  OTCLIB_ENSURE((theLink != 0),
   "OTC_DequeI::remove() - invalid link");
  OTCLIB_ENSURE((theLink->isLink()),
   "OTC_DequeI::remove() - not a link");

  if (!theLink->isDead())
  {
    myCount->dec();
    theLink->kill();
  }
}

/* ------------------------------------------------------------------------- */
void OTC_DequeI::removeFirst()
{
  OTCLIB_ENSURE((myCount->count() != 0),
   "OTC_DequeI::removeFirst() - List is empty");

  myCount->dec();
  myList->first()->kill();
}

/* ------------------------------------------------------------------------- */
void OTC_DequeI::removeLast()
{
  OTCLIB_ENSURE((myCount->count() != 0),
   "OTC_DequeI::removeLast() - List is empty");

  myCount->dec();
  myList->last()->kill();
}

/* ------------------------------------------------------------------------- */
OTC_Link* OTC_DequeI::first() const
{
  OTCLIB_ENSURE((myCount->count() != 0),
   "OTC_DequeI::first() - List is empty");

  return myList->first();
}

/* ------------------------------------------------------------------------- */
OTC_Link* OTC_DequeI::last() const
{
  OTCLIB_ENSURE((myCount->count() != 0),
   "OTC_DequeI::last() - List is empty");

  return myList->last();
}

/* ------------------------------------------------------------------------- */
void OTC_DequeI::addFirst(OTC_Link* theLink)
{
  OTCLIB_ENSURE((theLink != 0),
   "OTC_DequeI::addFirst(OTC_Link*) - Invalid link");

  myList->addFirst(theLink);
  myCount->inc();
}

/* ------------------------------------------------------------------------- */
void OTC_DequeI::addLast(OTC_Link* theLink)
{
  OTCLIB_ENSURE((theLink != 0),
   "OTC_DequeI::addLast(OTC_Link*) - Invalid link");

  myList->addLast(theLink);
  myCount->inc();
}

/* ------------------------------------------------------------------------- */
void OTC_DequeI::addBeforeLink(OTC_Link* theNewLink, OTC_Link* theOldLink)
{
  OTCLIB_ENSURE((theNewLink != 0 && theOldLink != 0),
   "OTC_DequeI::addBeforeLink(OTC_Link*) - Invalid link");

  if (theOldLink->isLink() || theOldLink->prev() != 0)
    theOldLink->addBefore(theNewLink);
  else
    theOldLink->addAfter(theNewLink);

  myCount->inc();
}

/* ------------------------------------------------------------------------- */
void OTC_DequeI::addAfterLink(OTC_Link* theNewLink, OTC_Link* theOldLink)
{
  OTCLIB_ENSURE((theNewLink != 0 && theOldLink != 0),
   "OTC_DequeI::addAfterLink(OTC_Link*) - Invalid link");

  if (theOldLink->isLink() || theOldLink->next() != 0)
    theOldLink->addAfter(theNewLink);
  else
    theOldLink->addBefore(theNewLink);

  myCount->inc();
}

/* ------------------------------------------------------------------------- */
