/*
// ============================================================================
//
// = LIBRARY
//     OTC
// 
// = FILENAME
//     collctn/otciilink.cc
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1995 DUMPLETON SOFTWARE CONSULTING PTY LIMITED
//
// ============================================================================
*/

#ifdef __GNUG__
#pragma implementation "OTC/collctn/iilink.hh"
#endif

#include <OTC/collctn/iilink.hh>
#include <OTC/collctn/icursor.hh>
#include <OTC/collctn/kcursor.hh>
#include <OTC/collctn/kicursor.hh>

/* ------------------------------------------------------------------------- */
OTC_IILink::~OTC_IILink()
{
  // Nothing to do.
}

/* ------------------------------------------------------------------------- */
OTC_IILink::OTC_IILink(int theKey, int theItem)
  : _key(theKey), _item(theItem)
{
  // Nothing to do.
}

/* ------------------------------------------------------------------------- */
OTC_IILink::OTC_IILink(OTC_IILink const& theLink)
  : _key(theLink._key), _item(theLink._item)
{
  // Nothing to do.
}

#if defined(ENV_OSTORE)
/* ------------------------------------------------------------------------- */
static void bogus()
{
  // This function exists so as to trick the Sun C++ CAFE compiler
  // and Micro$oft compilers into generating templates for the listed
  // template cursor classes.

  OTC_LinkList* theList;

  OTC_Cursor<int>* theCursor;
  theCursor = new OTC_ItemCursor<int,OTC_IILink>(theList);
  delete theCursor;
  theCursor = new OTC_KeyCursor<int,OTC_IILink>(theList);
  delete theCursor;

  OTC_PairCursor<int,int>* thePairCursor;
  thePairCursor = new OTC_KeyItemCursor<int,int,OTC_IILink>(theList);
  delete thePairCursor;
}
#endif

/* ------------------------------------------------------------------------- */
