/*
// ============================================================================
//
// = LIBRARY
//     OTC
//
// = FILENAME
//     collctn/otclinkable.cc
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1992 1993 OTC LIMITED
//
// ============================================================================
*/

#ifdef __GNUG__
#pragma implementation "OTC/collctn/linkable.hh"
#endif

#include <OTC/collctn/linkable.hh>

/* ------------------------------------------------------------------------- */
OTC_Linkable::OTC_Linkable(OTC_Boolean theIsLink)
  : myPrev(0), myNext(0), myCount(0), myIsLink(theIsLink),
    myIsDead(OTCLIB_FALSE)
{
  // Always create first reference explicitly. The corresponding
  // call to <unReference()> for this is done by <kill()>.

  reference();
}

/* ------------------------------------------------------------------------- */
OTC_Linkable::~OTC_Linkable()
{
  OTCLIB_ASSERT(myCount == 0);

  unlink();
}

/* ------------------------------------------------------------------------- */
void OTC_Linkable::unlink()
{
  // Make adjacent objects point around this object.

  if (prev() != 0)
    prev()->setNext(next());
  if (next() != 0)
    next()->setPrev(prev());

  // Clear dangling pointers in this link.

  setPrev(0);
  setNext(0);
}

/* ------------------------------------------------------------------------- */
void OTC_Linkable::kill()
{
  if (!isDead())
  {
    // myCount = -myCount;

    myIsDead = OTCLIB_TRUE;

    // This call to <unReference()> matches the call to <reference()>
    // performed by the constructor.

    unReference();
  }
}

/* ------------------------------------------------------------------------- */
void OTC_Linkable::addBefore(OTC_Linkable* theObject)
{
  // Error on a null value or attempt to add this object or the object
  // already occuring before this object, before here.

  OTCLIB_ENSURE((theObject != 0),
   "OTC_Linkable::addBefore() - Must have valid object to insert");
  OTCLIB_ENSURE((theObject != this),
   "OTC_Linkable::addBefore() - Can't insert myself");

  // Unlink object from any other list which it may be a part of.

  if (theObject->prev() != 0 || theObject->next() != 0)
  {
    OTCLIB_ENSURE((theObject->isLink()),
     "OTC_Linkable::addBefore() - Can't relocate an anchor point");
    theObject->unlink();
  }

  // Setup links to include object in this list.

  theObject->setPrev(prev());
  theObject->setNext(this);
  if (prev() != 0)
    prev()->setNext(theObject);
  setPrev(theObject);
}

/* ------------------------------------------------------------------------- */
void OTC_Linkable::addAfter(OTC_Linkable* theObject)
{
  // Error on a null value or attempt to add this object or the object
  // already occuring after this object, after here.

  OTCLIB_ENSURE((theObject != 0),
   "OTC_Linkable::addAfter() - Must have valid object to insert");
  OTCLIB_ENSURE((theObject != this),
   "OTC_Linkable::addAfter() - Can't insert myself");

  // Unlink object from any other list which it may be a part of.

  if (theObject->prev() != 0 || theObject->next() != 0)
  {
    OTCLIB_ENSURE((theObject->isLink()),
     "OTC_Linkable::addAfter() - Can't relocate an anchor point");
    theObject->unlink();
  }

  // Setup links to include object in this list.

  theObject->setNext(next());
  theObject->setPrev(this);
  if (next() != 0)
    next()->setPrev(theObject);
  setNext(theObject);
}

/* ------------------------------------------------------------------------- */
void OTC_Linkable::reference()
{
  // if (isDead())
  //   myCount--;
  // else
  //   myCount++;

  myCount++;
}

/* ------------------------------------------------------------------------- */
void OTC_Linkable::unReference()
{
  OTCLIB_ENSURE((myCount > 0),
   "OTC_Linkable::unReference() - Link is not referenced");

  // if (isDead())
  //  myCount++;
  // else
  //  myCount--;

  myCount--;

  if (myCount == 0)
    delete this;
}

/* ------------------------------------------------------------------------- */
