/*
// ============================================================================
//
// = LIBRARY
//     OTC
// 
// = FILENAME
//     collctn/otclinkcurs.cc
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1993 TELSTRA CORPORATION LIMITED
//     Copyright 1995 DUMPLETON SOFTWARE CONSULTING PTY LIMITED
//
// ============================================================================
*/

#ifdef __GNUG__
#pragma implementation "OTC/collctn/linkcurs.hh"
#endif

#include <OTC/collctn/linkcurs.hh>
#include <OTC/collctn/linklist.hh>

/* ------------------------------------------------------------------------- */
OTC_LinkCursor::~OTC_LinkCursor()
{
  if (myProtection == OTCLIB_SAFE)
    myList->unReference();

  delete myIter;
}

/* ------------------------------------------------------------------------- */
OTC_LinkCursor::OTC_LinkCursor(
 OTC_LinkList* theList,
 OTC_Direction theDirection,
 OTC_Protection theProtection
)
  : myList(theList), myIter(0), myDirection(theDirection),
    myProtection(theProtection)
{
  OTCLIB_ASSERT(myList != 0);

  OTC_LinkIterator const& tmpIter = myList->items(theProtection);

#if defined(ENV_OSTORE_DML) || defined(ENV_OSTORE)
  OTC_Locality theLocality = OTC_Locality::of(this);
#endif

#if defined(ENV_OSTORE_DML)
  myIter = new ((os_segment*)theLocality) OTC_LinkIterator(tmpIter);
#else
#if defined(ENV_OSTORE)
  myIter = new (theLocality,OTC_LinkIterator::get_os_typespec())
   OTC_LinkIterator(tmpIter);
#else
  myIter = new OTC_LinkIterator(tmpIter);
#endif
#endif
  OTCLIB_ASSERT(myIter != 0);

  if (myProtection == OTCLIB_SAFE)
    myList->reference();

  reset();
}

/* ------------------------------------------------------------------------- */
OTC_LinkCursor::OTC_LinkCursor(
 OTC_LinkList* theList,
 OTC_Linkable* theStart,
 OTC_Linkable* theEnd,
 OTC_Direction theDirection,
 OTC_Protection theProtection
)
  : myList(theList), myIter(0), myDirection(theDirection),
    myProtection(theProtection)
{
  OTCLIB_ASSERT(myList != 0);

#if defined(ENV_OSTORE_DML) || defined(ENV_OSTORE)
  OTC_Locality theLocality = OTC_Locality::of(this);
#endif

#if defined(ENV_OSTORE_DML)
  myIter = new ((os_segment*)theLocality)
   OTC_LinkIterator(theStart,theEnd,theProtection);
#else
#if defined(ENV_OSTORE)
  myIter = new (theLocality,OTC_LinkIterator::get_os_typespec())
   OTC_LinkIterator(theStart,theEnd,theProtection);
#else
  myIter = new OTC_LinkIterator(theStart,theEnd,theProtection);
#endif
#endif
  OTCLIB_ASSERT(myIter != 0);

  if (myProtection == OTCLIB_SAFE)
    myList->reference();

  reset();
}

/* ------------------------------------------------------------------------- */
OTC_LinkCursor::OTC_LinkCursor(
 OTC_LinkCursor const& theIter
)
  : myList(theIter.myList), myIter(0), myDirection(theIter.myDirection),
    myProtection(theIter.myProtection)
{
  OTCLIB_ASSERT(myList != 0);

#if defined(ENV_OSTORE_DML) || defined(ENV_OSTORE)
  OTC_Locality theLocality = OTC_Locality::of(this);
#endif

#if defined(ENV_OSTORE_DML)
    myIter = new ((os_segment*)theLocality) OTC_LinkIterator(*theIter.myIter);
#else
#if defined(ENV_OSTORE)
  myIter = new (theLocality,OTC_LinkIterator::get_os_typespec())
   OTC_LinkIterator(*theIter.myIter);
#else
  myIter = new OTC_LinkIterator(*theIter.myIter);
#endif
#endif
  OTCLIB_ASSERT(myIter != 0);

  if (myProtection == OTCLIB_SAFE)
    myList->reference();
}

/* ------------------------------------------------------------------------- */
