/*
// ============================================================================
//
// = LIBRARY
//     OTC
//
// = FILENAME
//     collctn/otclinkiter.cc
//
// = AUTHOR(S)
//     Graham Dumpleton
//
// = COPYRIGHT
//     Copyright 1992 OTC LIMITED
//
// ============================================================================
*/

#ifdef __GNUG__
#pragma implementation "OTC/collctn/linkiter.hh"
#endif

#include <OTC/collctn/linkiter.hh>
#include <OTC/collctn/link.hh>

#if defined(ENV_OSTORE)
/* ------------------------------------------------------------------------- */
os_typespec* OTC_LinkIterator::typespec()
{
  static os_typespec ts("OTC_LinkIterator");
  return &ts;
}
#endif

/* ------------------------------------------------------------------------- */
OTC_LinkIterator::~OTC_LinkIterator()
{
  if (myProtection == OTCLIB_SAFE)
  {
    myLink->unReference();
    myStart->unReference();
    myEnd->unReference();
  }
}

/* ------------------------------------------------------------------------- */
OTC_LinkIterator::OTC_LinkIterator(
 OTC_Linkable* theStart,
 OTC_Linkable* theEnd,
 OTC_Protection theProtection
)
  : myStart(theStart),
    myEnd(theEnd),
    myLink(theStart),
    myProtection(theProtection)
{
  OTCLIB_ENSURE((theStart != 0 && theEnd != 0),
   "OTC_LinkIterator::OTC_LinkIterator() - Invalid anchor point");

  if (myProtection == OTCLIB_SAFE)
  {
    myStart->reference();
    myEnd->reference();
    myLink->reference();
  }
}

/* ------------------------------------------------------------------------- */
OTC_LinkIterator::OTC_LinkIterator(OTC_LinkIterator const& theIter)
  : myStart(theIter.myStart),
    myEnd(theIter.myEnd),
    myLink(theIter.myLink),
    myProtection(theIter.myProtection)
{
  if (myProtection == OTCLIB_SAFE)
  {
    myStart->reference();
    myEnd->reference();
    myLink->reference();
  }
}

/* ------------------------------------------------------------------------- */
OTC_LinkIterator& OTC_LinkIterator::operator=(OTC_LinkIterator const& theIter)
{
  if (theIter.myProtection == OTCLIB_SAFE)
  {
    theIter.myStart->reference();
    theIter.myEnd->reference();
    theIter.myLink->reference();
  }

  if (myProtection == OTCLIB_SAFE)
  {
    myStart->unReference();
    myEnd->unReference();
    myLink->unReference();
  }

  myStart = theIter.myStart;
  myEnd = theIter.myEnd;
  myLink = theIter.myLink;
  myProtection = theIter.myProtection;

  return *this;
}

/* ------------------------------------------------------------------------- */
void OTC_LinkIterator::next()
{
  OTCLIB_ASSERT(myLink != 0);

  if (myLink == myEnd)
    return;

  else
  {
    OTC_Linkable* aLink = myLink->next();
    while (OTCLIB_TRUE)
    {
      OTCLIB_ASSERT(aLink != 0);

      if (aLink == myEnd)
	break;

      else if (aLink->isLink() && !aLink->isDead())
	break;

      else
	aLink = aLink->next();
    }
    locate(aLink);
  }
}

/* ------------------------------------------------------------------------- */
void OTC_LinkIterator::prev()
{
  OTCLIB_ASSERT(myLink != 0);

  if (myLink == myStart)
    return;

  else
  {
    OTC_Linkable* aLink = myLink->prev();
    while (OTCLIB_TRUE)
    {
      OTCLIB_ASSERT(aLink != 0);

      if (aLink == myStart)
	break;

      else if (aLink->isLink() && !aLink->isDead())
	break;

      else
	aLink = aLink->prev();
    }
    locate(aLink);
  }
}

/* ------------------------------------------------------------------------- */
void OTC_LinkIterator::locate(OTC_Linkable* theLink)
{
  if (myLink != theLink)
  {
    if (myProtection == OTCLIB_SAFE)
    {
      theLink->reference();
      myLink->unReference();
    }
    myLink = theLink;
  }
}

/* ------------------------------------------------------------------------- */
