/*
// ============================================================================
//
// = LIBRARY
//     OTC
//
// = FILENAME
//     collctn/otclinklist.cc
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1992 OTC LIMITED
//     Copyright 1994 1995 DUMPLETON SOFTWARE CONSULTING PTY LIMITED
//
// = NOTES
//     ObjectStore compiler sometimes has problems comparing pointers
//     which are of a different type but where they are related through
//     inheritance. Thus have to cast <OTC_Anchor*> when comparing
//     against <OTC_Linkable*>.
//
// ============================================================================
*/

#ifdef __GNUG__
#pragma implementation "OTC/collctn/linklist.hh"
#endif

#include <OTC/collctn/linklist.hh>

#if defined(ENV_OSTORE)
/* ------------------------------------------------------------------------- */
os_typespec* OTC_LinkList::typespec()
{
  static os_typespec ts("OTC_LinkList");
  return &ts;
}
#endif

/* ------------------------------------------------------------------------- */
OTC_LinkList::OTC_LinkList()
{
#if defined(ENV_OSTORE_DML) || defined(ENV_OSTORE)
  OTC_Locality theLocality = OTC_Locality::of(this);
#endif

#if defined(ENV_OSTORE_DML)
  myStart = new ((os_segment*)theLocality) OTC_Anchor;
#else
#if defined(ENV_OSTORE)
  myStart = new (theLocality,OTC_Anchor::get_os_typespec()) OTC_Anchor;
#else
  myStart = new OTC_Anchor;
#endif
#endif
  OTCLIB_ASSERT(myStart != 0);

#if defined(ENV_OSTORE_DML)
    myEnd = new ((os_segment*)theLocality) OTC_Anchor;
#else
#if defined(ENV_OSTORE)
  myEnd = new (theLocality,OTC_Anchor::get_os_typespec()) OTC_Anchor;
#else
  myEnd = new OTC_Anchor;
#endif
#endif
  OTCLIB_ASSERT(myEnd != 0);

  myStart->addAfter(myEnd);
}

/* ------------------------------------------------------------------------- */
OTC_LinkList::~OTC_LinkList()
{
  removeAll();
  myStart->kill();
  myEnd->kill();
}

/* ------------------------------------------------------------------------- */
void OTC_LinkList::removeAll()
{
  OTC_Linkable* theLink = myStart->next();
  while (theLink != myEnd)
  {
    OTCLIB_ASSERT(theLink != 0);

    OTC_Linkable* nextLink = theLink->next();
    if (!theLink->isDead())
      theLink->kill();
    theLink = nextLink;
  }
}

/* ------------------------------------------------------------------------- */
OTC_Link* OTC_LinkList::first() const
{
  OTC_Linkable* theLink = myStart->next();
  while (theLink != (OTC_Linkable*)myEnd)
  {
    OTCLIB_ASSERT(theLink != 0);

    if (theLink->isLink() && !theLink->isDead())
      return (OTC_Link*)theLink;

    theLink = theLink->next();
  }
  return 0;
}

/* ------------------------------------------------------------------------- */
OTC_Link* OTC_LinkList::last() const
{
  OTC_Linkable* theLink = myEnd->prev();
  while (theLink != (OTC_Linkable*)myStart)
  {
    OTCLIB_ASSERT(theLink != 0);

    if (theLink->isLink() && !theLink->isDead())
      return (OTC_Link*)theLink;

    theLink = theLink->prev();
  }
  return 0;
}

/* ------------------------------------------------------------------------- */
u_int OTC_LinkList::population() const
{
  u_int thePopulation = 0;

  OTC_Linkable* theLink = myStart->next();
  while (theLink != (OTC_Linkable*)myEnd)
  {
    OTCLIB_ASSERT(theLink != 0);

    if (theLink->isLink() && !theLink->isDead())
      thePopulation++;

    theLink = theLink->next();
  }
  return thePopulation;
}

/* ------------------------------------------------------------------------- */
OTC_Boolean OTC_LinkList::isEmpty() const
{
  OTC_Linkable* theLink = myStart->next();
  while (theLink != (OTC_Linkable*)myEnd)
  {
    OTCLIB_ASSERT(theLink != 0);

    if (theLink->isLink() && !theLink->isDead())
      return OTCLIB_FALSE;

    theLink = theLink->next();
  }
  return OTCLIB_TRUE;
}

/* ------------------------------------------------------------------------- */
void OTC_LinkList::removeFirst()
{
  OTC_Link* theLink;
  theLink = first();

  OTCLIB_ENSURE((theLink != 0),
   "OTC_LinkList::removeFirst() - list is empty");

  theLink->kill();
}

/* ------------------------------------------------------------------------- */
void OTC_LinkList::removeLast()
{
  OTC_Link* theLink;
  theLink = last();

  OTCLIB_ENSURE((theLink != 0),
   "OTC_LinkList::removeLast() - list is empty");

  theLink->kill();
}

/* ------------------------------------------------------------------------- */
