/*
// ============================================================================
//
// = LIBRARY
//     OTC
// 
// = FILENAME
//     collctn/otclisti.cc
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1994 1995 DUMPLETON SOFTWARE CONSULTING PTY LIMITED
//
// ============================================================================
*/

#ifdef __GNUG__
#pragma implementation "OTC/collctn/listi.hh"
#endif

#include <OTC/collctn/listi.hh>
#include <OTC/collctn/avllnode.hh>

/* ------------------------------------------------------------------------- */
OTC_ListI::~OTC_ListI()
{
  myTree->unReference();
  myList->unReference();
}

/* ------------------------------------------------------------------------- */
OTC_ListI::OTC_ListI()
{
#if defined(ENV_OSTORE_DML) || defined(ENV_OSTORE)
  OTC_Locality theLocality = OTC_Locality::of(this);
#endif

#if defined(ENV_OSTORE_DML)
  myList = new ((os_segment*)theLocality) OTC_LinkList;
#else
#if defined(ENV_OSTORE)
  myList = new (theLocality,OTC_LinkList::get_os_typespec()) OTC_LinkList;
#else
  myList = new OTC_LinkList;
#endif
#endif
  OTCLIB_ASSERT(myList != 0);
  myList->reference();

#if defined(ENV_OSTORE_DML)
  myTree = new ((os_segment*)theLocality) OTC_AVLTree;
#else
#if defined(ENV_OSTORE)
  myTree = new (theLocality,OTC_AVLTree::get_os_typespec()) OTC_AVLTree;
#else
  myTree = new OTC_AVLTree;
#endif
#endif
  OTCLIB_ASSERT(myTree != 0);
  myTree->reference();
}

/* ------------------------------------------------------------------------- */
OTC_ListI::OTC_ListI(OTC_ListI const& theList)
{
  myList = theList.myList;
  myList->reference();

  myTree = theList.myTree;
  myTree->reference();
}

/* ------------------------------------------------------------------------- */
OTC_Link* OTC_ListI::first() const
{
  OTCLIB_ENSURE((myTree->population() != 0),
   "OTC_ListI::first() - List is empty");

  return myList->first();
}

/* ------------------------------------------------------------------------- */
OTC_Link* OTC_ListI::last() const
{
  OTCLIB_ENSURE((myTree->population() != 0),
   "OTC_ListI::last() - List is empty");

  return myList->last();
}

/* ------------------------------------------------------------------------- */
OTC_Link* OTC_ListI::item(int theIndex) const
{
  OTCLIB_ENSURE((theIndex >= 0 && theIndex < (int)myTree->population()),
   "OTC_ListI::item() - Index out of range");

  if (theIndex == 0)
    return first();

  else if (theIndex == (int)myTree->population()-1)
    return last();

  else
  {
    OTC_AVLNode* theNode = myTree->node(theIndex);
    return ((OTC_AVLLinkNode*)theNode)->link();
  }
}

/* ------------------------------------------------------------------------- */
void OTC_ListI::addBeforeItem(OTC_Link* theLink, int theIndex)
{
  OTCLIB_ENSURE((theLink != 0),
   "OTC_ListI::addBeforeItem() - Invalid link");
  OTCLIB_ENSURE((theIndex >= 0 && theIndex <= (int)myTree->population()),
   "OTC_ListI::addBeforeItem() - Index out of range");

#if defined(ENV_OSTORE_DML) || defined(ENV_OSTORE)
  OTC_Locality theLocality = OTC_Locality::of(this);
#endif

  OTC_AVLLinkNode* theLinkNode;
#if defined(ENV_OSTORE_DML)
  theLinkNode = new ((os_segment*)theLocality) OTC_AVLLinkNode(theLink);
#else
#if defined(ENV_OSTORE)
  theLinkNode = new (theLocality,OTC_AVLLinkNode::get_os_typespec())
   OTC_AVLLinkNode(theLink);
#else
  theLinkNode = new OTC_AVLLinkNode(theLink);
#endif
#endif
  OTCLIB_ASSERT(theLinkNode);

  if (theIndex == 0 && population() == 0)
  {
    myList->addFirst(theLink);
    myTree->addRoot(theLinkNode);
  }
  else
  {
    if (theIndex == (int)population())
    {
      OTC_AVLLinkNode* tmpLinkNode;
      tmpLinkNode = (OTC_AVLLinkNode*)myTree->node(theIndex-1);
      OTCLIB_ASSERT(tmpLinkNode != 0);
      tmpLinkNode->link()->addAfter(theLink);
      tmpLinkNode->addAfter(theLinkNode);
    }
    else
    {
      OTC_AVLLinkNode* tmpLinkNode;
      tmpLinkNode = (OTC_AVLLinkNode*)myTree->node(theIndex);
      OTCLIB_ASSERT(tmpLinkNode != 0);
      tmpLinkNode->link()->addBefore(theLink);
      tmpLinkNode->addBefore(theLinkNode);
    }
  }
}

/* ------------------------------------------------------------------------- */
void OTC_ListI::removeItem(int theIndex)
{
  OTCLIB_ENSURE((myTree->population() != 0),
   "OTC_ListI::removeItem() - List is empty");
  OTCLIB_ENSURE((theIndex >= 0 && theIndex < (int)myTree->population()),
   "OTC_List::removeItem() - Index out of range");

  OTC_AVLNode* theNode = myTree->node(theIndex);
  OTCLIB_ASSERT(theNode != 0);

  theNode->unlink();
  ((OTC_AVLLinkNode*)theNode)->link()->kill();
  delete theNode;
}

/* ------------------------------------------------------------------------- */
void OTC_ListI::removeRange(int theStart, u_int theLength)
{
  OTCLIB_ENSURE((theStart >= 0 && theStart+theLength <= myTree->population()),
   "OTC_ListI::removeRange() - Invalid range");

  while (theLength-- > 0)
    removeItem(theStart+theLength);
}

/* ------------------------------------------------------------------------- */
