/*
// ============================================================================
//
// = LIBRARY
//     OTC
// 
// = FILENAME
//     collctn/otcrngecurs.cc
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1992 OTC LIMITED
//     Copyright 1994 1995 DUMPLETON SOFTWARE CONSULTING PTY LIMITED
//
// ============================================================================
*/

#ifdef __GNUG__
#pragma implementation "OTC/collctn/rngecurs.hh"
#endif

#include <OTC/collctn/rngecurs.hh>

#if defined(ENV_OSTORE)
/* ------------------------------------------------------------------------- */
os_typespec* OTC_RangeCursor::typespec()
{
  static os_typespec ts("OTC_RangeCursor");
  return &ts;
}
#endif

/* ------------------------------------------------------------------------- */
OTC_RangeCursor::~OTC_RangeCursor()
{
  // Nothing to do.
}

/* ------------------------------------------------------------------------- */
OTC_RangeCursor::OTC_RangeCursor(
 int theLower,
 u_int theLength,
 OTC_Direction theDirection
)
  : myLower(theLower), myUpper(theLower+theLength), myDirection(theDirection)
{
  reset();
}

/* ------------------------------------------------------------------------- */
void OTC_RangeCursor::reset()
{
  if (myDirection == OTCLIB_FORWARD)
    myCurrent = myLower;
  else
    myCurrent = myUpper - 1;
}

/* ------------------------------------------------------------------------- */
void OTC_RangeCursor::next()
{
  if (myCurrent >= myLower && myCurrent < myUpper)
  {
    if (myDirection == OTCLIB_FORWARD)
      myCurrent++;
    else
      myCurrent--;
  }
}

/* ------------------------------------------------------------------------- */
int& OTC_RangeCursor::item()
{
  OTCLIB_ENSURE((isValid()),
   "OTC_RangeCursor::item() - No item under cursor");
  return myCurrent;
}

/* ------------------------------------------------------------------------- */
OTC_Boolean OTC_RangeCursor::isValid() const
{
  return myCurrent >= myLower && myCurrent < myUpper;
}

/* ------------------------------------------------------------------------- */
OTC_Cursor<int>* OTC_RangeCursor::clone()
{
#if defined(ENV_OSTORE_DML) || defined(ENV_OSTORE)
  OTC_Locality theLocality = OTC_Locality::of(this);
#endif

  OTC_RangeCursor* theCursor;
#if defined(ENV_OSTORE_DML)
  theCursor = new ((os_segment*)theLocality) OTC_RangeCursor(*this);
#else
#if defined(ENV_OSTORE)
  theCursor = new (theLocality,OTC_RangeCursor::get_os_typespec())
   OTC_RangeCursor(*this);
#else
  theCursor = new OTC_RangeCursor(*this);
#endif
#endif
  OTCLIB_ASSERT(theCursor != 0);
  return theCursor;
}

/* ------------------------------------------------------------------------- */
OTC_RangeCursor::OTC_RangeCursor(OTC_RangeCursor const& theCursor)
  : myLower(theCursor.myLower),
    myUpper(theCursor.myUpper),
    myDirection(theCursor.myDirection),
    myCurrent(theCursor.myCurrent)
{
  // Nothing to do.
}

/* ------------------------------------------------------------------------- */
