/*
// ============================================================================
//
// = LIBRARY
//     OTC
// 
// = FILENAME
//     collctn/otcstrgactn.cc
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1993 OTC LIMITED
//
// ============================================================================
*/

#ifdef __GNUG__
#pragma implementation "OTC/collctn/strgactn.hh"
#endif

#include <OTC/collctn/strgactn.hh>

#include <string.h>
#include <stdlib.h>

/* ------------------------------------------------------------------------- */
int OTCLIB_STRRANDDATASIZE = 256;
int OTCLIB_STRRANDDATA[] =
{
  728127828, 1059808615, 189099567, 1782392777, 2015910634, 1464233364,
  2117154627, 320296558, 1031062195, 1806953707, 1269105328, 244848173,
  188610040, 1102847359, 955979572, 332343558, 1444727546, 1324212966,
  1548364501, 1115311523, 1099957056, 1169413381, 2093789469, 1563302844,
  461628862, 1107584071, 301563892, 1879173093, 815149643, 1564775192,
  1840721837, 1543277471, 477100159, 2029821404, 1178186600, 345527146,
  1346571120, 1147857580, 665823704, 230149667, 807327639, 1934929033,
  474997841, 995937680, 890292744, 1430977413, 1328281238, 187536642,
  607706732, 729162092, 1302848165, 1707663788, 1898575473, 1249153986,
  1123482984, 212720687, 209254410, 1425046876, 2091893780, 1024404053,
  842338421, 1785131969, 420197876, 1319438580, 1667469725, 1598384476,
  1664965726, 866557198, 598758408, 183305783, 1096706865, 1406086048,
  2118234816, 1571704706, 254540080, 861043912, 855198472, 1582821318,
  1048580554, 1462905204, 164499762, 203945071, 1023085344, 2063075236,
  1453099057, 2146568329, 128312275, 1662353467, 1424131557, 72722408,
  539273872, 118986330, 1857854377, 959471748, 1438424911, 1377840455,
  410372577, 955906989, 96914005, 1009130985, 1139212772, 1193620870,
  267733385, 1109963940, 617841929, 522273465, 1971007852, 1473040401,
  2105094784, 872104758, 788461957, 122110898, 1076049829, 1811547301,
  37702486, 381665239, 1810631982, 166014762, 2044018706, 1087279892,
  238737170, 435808931, 1206266222, 2096591547, 1395280679, 497207485,
  1326948354, 1805653256, 1453114475, 1423862359, 667300594, 444843599,
  469999582, 935033979, 1554807540, 1087841511, 1457307445, 1378331744,
  413398264, 1414918581, 102952855, 1201860221, 1537029479, 1179002684,
  865923874, 1574731966, 1560667923, 529072209, 1740746728, 1457202982,
  1616352101, 1979483898, 1893011913, 675134675, 1928591797, 1140808944,
  1172342161, 1108056504, 798978553, 477972988, 384435215, 1466279147,
  922816587, 854434797, 253829478, 330140479, 1942276308, 1711136923,
  1708472224, 208190924, 978571856, 1811425079, 1410051145, 368117688,
  842944115, 128491372, 1942849654, 256128391, 657563581, 1536112734,
  1713331373, 126432034, 1368112984, 1458859638, 801566709, 1149221133,
  452184934, 1973908870, 109793989, 1251163487, 304398210, 494229205,
  569958986, 1227214798, 1348664002, 823788465, 1557355277, 1143456663,
  387441740, 1118343853, 1351647587, 1366013597, 782285284, 614215085,
  1734131285, 1625229400, 742706457, 1529497291, 1881357791, 1400270038,
  918126377, 1447205516, 1526702072, 138755713, 758581506, 180785133,
  1287976846, 1210766440, 7210356, 1397770836, 314446280, 311608566,
  1892000041, 884405266, 1538823364, 1093180395, 1708193731, 948694994,
  89153410, 2095635472, 2067038847, 1440800998, 1314165421, 701840484,
  2055016083, 900813058, 179586236, 650238892, 282826701, 2060944027,
  2050508930, 1200953078, 1360665895, 1429727354, 1339708791, 2119247401,
  1610512487, 480201989, 1182530193, 1617722843, 1877972825, 1496976473,
  1929331410, 1622489218, 233898092, 1320671126
};

/* ------------------------------------------------------------------------- */
typedef const char* otclib_charCP;

/* ------------------------------------------------------------------------- */
int otclib_hash(char const* s)
{
  if (s == 0 || *s == EOS)
    return 0;

  int h = 0;
  while (*s != EOS)
  {
    h ^= OTCLIB_STRRANDDATA[(*s + h) & (OTCLIB_STRRANDDATASIZE-1)];
    s++;
  }
  return h;
}

/* ------------------------------------------------------------------------- */
int otclib_hash(char const* s, int l)
{
  if (s == 0 || l <= 0)
    return 0;

  int h = 0;
  l--;
  while (l >= 0)
  {
    h ^= OTCLIB_STRRANDDATA[(s[l] + h) & (OTCLIB_STRRANDDATASIZE-1)];
    l--;
  }
  return h;
}

#if defined(CXX_OS)
/* ------------------------------------------------------------------------- */
int OTC_HashActions<char*>::hash(char* const& s)
{
  return otclib_hash(s);
}

/* ------------------------------------------------------------------------- */
#ifdef CXX_OS
int OTC_HashActions<const char*>::hash(otclib_charCP const& s)
#else
int OTC_HashActions<const char*>::hash(const char* const& s)
#endif
{
  return otclib_hash(s);
}
#endif

/* ------------------------------------------------------------------------- */
int otclib_rank(char const* s1, char const* s2)
{
  if (s1 == s2)
    return 0;

  else if (s1 == 0)
    return -1;

  else if (s2 == 0)
    return 1;

  else
  {
    int res = strcmp(s1,s2);
    if (res < 0)
      return -1;

    else if (res > 0)
      return 1;

    else
      return 0;
  }
}

#if defined(CXX_OS)
/* ------------------------------------------------------------------------- */
int OTC_RankActions<char*>::rank(char* const& s1, char* const& s2)
{
  return otclib_rank(s1,s2);
}

/* ------------------------------------------------------------------------- */
#ifdef CXX_OS
int OTC_RankActions<const char*>::rank(
 otclib_charCP const& s1,
 otclib_charCP const& s2
)
#else
int OTC_RankActions<const char*>::rank(
 const char* const& s1,
 const char* const& s2
)
#endif
{
  return otclib_rank(s1,s2);
}
#endif

/* ------------------------------------------------------------------------- */

/*  $Revision: 1.1.1.1 $
**
**  This file has been modified to get it to compile more easily
**  on pre-4.4BSD systems.  Rich $alz, June 1991.
*/
#if 0
#define const /* NULL */
#define void char
#define size_t int
#define NULL 0
#define MEMCOPY
#endif

/*-
 * Copyright (c) 1990 The Regents of the University of California.
 * All rights reserved.
 *
 * This code is derived from software contributed to Berkeley by
 * Chris Torek.
 *
 * Redistribution and use in source and binary forms are permitted provided
 * that: (1) source distributions retain this entire copyright notice and
 * comment, and (2) distributions including binaries display the following
 * acknowledgement:  ``This product includes software developed by the
 * University of California, Berkeley and its contributors'' in the
 * documentation or other materials provided with the distribution and in
 * all advertising materials mentioning features or use of this software.
 * Neither the name of the University nor the names of its contributors may
 * be used to endorse or promote products derived from this software without
 * specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#if 0
#if defined(LIBC_SCCS) && !defined(lint)
static char sccsid[] = "@(#)bcopy.c	5.8 (Berkeley) 6/23/90";
#endif /* LIBC_SCCS and not lint */

#include <sys/stdc.h>
#include <string.h>
#endif

/*
 * sizeof(word) MUST BE A POWER OF TWO
 * SO THAT wmask BELOW IS ALL ONES
 */
typedef	int word;		/* "word" used for optimal copy speed */

#define	wsize	sizeof(word)
#define	wmask	(wsize - 1)

/*
 * Copy a block of memory, handling overlap.
 * This is the routine that actually implements
 * (the portable versions of) bcopy, memcpy, and memmove.
 */
#if 0
#ifdef MEMCOPY
void *
memcpy(dst0, src0, length)
#else
#ifdef MEMMOVE
void *
memmove(dst0, src0, length)
#else
void
bcopy(src0, dst0, length)
#endif
#endif
	char *dst0;
	const char *src0;
	register size_t length;
#endif
void otclib_memmove(char* dst0, char const* src0, size_t length)
{
	register char *dst = dst0;
	register const char *src = src0;
	register size_t t;

	if (length == 0 || dst == src)		/* nothing to do */
		goto retval;

	/*
	 * Macros: loop-t-times; and loop-t-times, t>0
	 */
#define	TLOOP(s) if (t) TLOOP1(s)
#define	TLOOP1(s) do { s; } while (--t)

	if ((size_t)dst < (size_t)src) {
		/*
		 * Copy forward.
		 */
		t = (size_t)src;	/* only need low bits */
		if ((t | (size_t)dst) & wmask) {
			/*
			 * Try to align operands.  This cannot be done
			 * unless the low bits match.
			 */
			if ((t ^ (size_t)dst) & wmask || length < wsize)
				t = length;
			else
				t = wsize - (t & wmask);
			length -= t;
			TLOOP1(*dst++ = *src++);
		}
		/*
		 * Copy whole words, then mop up any trailing bytes.
		 */
		t = length / wsize;
		TLOOP(*(word *)dst = *(word *)src; src += wsize; dst += wsize);
		t = length & wmask;
		TLOOP(*dst++ = *src++);
	} else {
		/*
		 * Copy backwards.  Otherwise essentially the same.
		 * Alignment works as before, except that it takes
		 * (t&wmask) bytes to align, not wsize-(t&wmask).
		 */
		src += length;
		dst += length;
		t = (size_t)src;
		if ((t | (size_t)dst) & wmask) {
			if ((t ^ (size_t)dst) & wmask || length <= wsize)
				t = length;
			else
				t &= wmask;
			length -= t;
			TLOOP1(*--dst = *--src);
		}
		t = length / wsize;
		TLOOP(src -= wsize; dst -= wsize; *(word *)dst = *(word *)src);
		t = length & wmask;
		TLOOP(*--dst = *--src);
	}
retval:
#ifdef MEMCOPY
	return(dst0);
#else
#ifdef MEMMOVE
	return(dst0);
#else
	return;
#endif
#endif
}

#if defined(CXX_OS)
/* ------------------------------------------------------------------------- */
void OTC_CopyActions<char>::copy(char* s1, char const* s2, size_t l)
{
  otclib_memmove(s1,s2,l);
}
#endif

/* ------------------------------------------------------------------------- */
